/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.flow;

import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPlugin;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.runner.RunnerException;
import org.specrunner.util.UtilLog;

public class PluginFor
extends AbstractPlugin {
    protected String var = "index";
    protected int min = 0;
    protected Integer max;
    protected int step = 1;

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    @Override
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("VAR(" + this.var + "),MIN(" + this.min + "),MAX(" + this.max + "),STEP(" + this.step + ")");
        }
        Node current = context.getNode();
        if (this.max == null) {
            result.addResult((Status)Failure.INSTANCE, context.newBlock(current, this), new PluginException("IPlugin  'max' attribute missing."));
            return ENext.SKIP;
        }
        if (this.min > this.max) {
            result.addResult((Status)Failure.INSTANCE, context.newBlock(current, this), new PluginException("IPlugin loop 'min'(" + this.min + ") cannot be greater than 'max'(" + this.max + ")"));
            return ENext.SKIP;
        }
        Node base = current.copy();
        while (current.getChildCount() > 0) {
            current.getChild(0).detach();
        }
        Element ele = (Element)current;
        ele.addAttribute(new Attribute("var", "" + this.var));
        ele.addAttribute(new Attribute("min", "" + this.min));
        ele.addAttribute(new Attribute("max", "" + this.max));
        ele.addAttribute(new Attribute("step", "" + this.step));
        for (int i = this.min; i < this.max; i += this.step) {
            Node dn = base.copy();
            while (dn.getChildCount() > 0) {
                Node child = dn.getChild(0);
                child.detach();
                ((ParentNode)current).appendChild(child);
                context.saveLocal(this.var, i);
                try {
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug("CHILD(" + i + ")>" + child.toXML());
                    }
                    try {
                        context.getRunner().run(child, context, result);
                    }
                    catch (RunnerException e) {
                        if (UtilLog.LOG.isDebugEnabled()) {
                            UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                        }
                        result.addResult((Status)Failure.INSTANCE, context.newBlock(current, this), e);
                    }
                }
                finally {
                    context.clearLocal(this.var);
                }
            }
            if (!UtilLog.LOG.isDebugEnabled()) continue;
            UtilLog.LOG.debug("BASE(" + i + ")>" + base.toXML());
        }
        return ENext.SKIP;
    }
}

