/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.flow;

import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginValue;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;

public class PluginIf
extends AbstractPluginValue {
    public static final String TEST_NAME = "ifTest";

    @Override
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        Element condition = (Element)context.getNode();
        Object valueCond = this.getValue(this.getValue() != null ? this.getValue() : condition.getValue(), true, context);
        if (!(valueCond instanceof Boolean)) {
            String strCon = String.valueOf(valueCond);
            if ("true".equalsIgnoreCase(strCon) || "false".equalsIgnoreCase(strCon)) {
                valueCond = Boolean.valueOf(strCon);
            } else {
                throw new PluginException("If contition result in invalid value: '" + valueCond + "'. Returned type:" + (valueCond != null ? valueCond.getClass() : "null"));
            }
        }
        String testName = this.getName() != null ? this.getName() : TEST_NAME;
        condition.addAttribute(new Attribute("name", testName));
        condition.addAttribute(new Attribute("branch", String.valueOf(valueCond)));
        this.saveLocal(context, testName, valueCond);
        return ENext.DEEP;
    }

    public static Boolean getTest(IContext context, String name) throws PluginException {
        String ifName = name != null ? name : TEST_NAME;
        Object ifObject = context.getByName(ifName);
        if (ifObject == null) {
            throw new PluginException("Conditional test with name '" + ifName + "' not found in context.");
        }
        if (!(ifObject instanceof Boolean)) {
            throw new PluginException("Conditional test with name '" + ifName + "' returned a '" + (ifObject != null ? ifObject.getClass().getName() : "null") + "' instance of an instance of Boolean.");
        }
        Node node = context.getNode();
        if (node instanceof Element) {
            ((Element)node).addAttribute(new Attribute("name", "" + ifName));
        }
        return (Boolean)ifObject;
    }
}

