/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.flow;

import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginNamed;
import org.specrunner.plugins.core.flow.PluginIf;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.util.xom.UtilNode;

public abstract class PluginIfBranch
extends AbstractPluginNamed {
    public static final String CSS_SELECTED = "selected";
    public static final String CSS_RELEGATED = "relegated";
    public static final String FEATURE_HIDE = PluginIfBranch.class.getName() + ".hide";
    private Boolean hide;

    public Boolean getHide() {
        return this.hide;
    }

    public void setHide(Boolean hide) {
        this.hide = hide;
    }

    @Override
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    @Override
    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        if (this.hide == null) {
            IFeatureManager fm = SRServices.getFeatureManager();
            fm.set(FEATURE_HIDE, this);
        }
    }

    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        Boolean ifResult = PluginIf.getTest(context, this.getName());
        Boolean condition = this.expected() == ifResult.booleanValue();
        this.encapsule(context, condition);
        return condition != false ? ENext.DEEP : ENext.SKIP;
    }

    protected void encapsule(IContext context, Boolean condition) {
        Node node = context.getNode();
        ParentNode parent = node.getParent();
        int index = parent.indexOf(node);
        Element enc = new Element("span");
        if (!condition.booleanValue()) {
            UtilNode.setIgnore((Node)enc);
        }
        UtilNode.appendCss(node, condition != false ? CSS_SELECTED : CSS_RELEGATED);
        node.detach();
        if (condition.booleanValue() || this.hide != null && !this.hide.booleanValue()) {
            enc.appendChild(node);
            parent.insertChild((Node)enc, index);
        }
    }

    protected abstract boolean expected();
}

