/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.flow;

import java.io.IOException;
import javax.swing.JOptionPane;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPlugin;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.util.UtilIO;
import org.specrunner.util.UtilLog;

public class PluginPause
extends AbstractPlugin {
    public static final String FEATURE_ENTER = PluginPause.class.getName() + ".enter";
    public static final String FEATURE_TIME = PluginPause.class.getName() + ".time";
    private boolean enter;
    private Long time;

    public boolean isEnter() {
        return this.enter;
    }

    public void setEnter(boolean enter) {
        this.enter = enter;
    }

    public Long getTime() {
        return this.time;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    @Override
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    @Override
    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_ENTER, this);
        if (this.time == null) {
            fm.set(FEATURE_TIME, this);
        }
    }

    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        if (this.getTime() != null) {
            try {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("(" + Thread.currentThread().getName() + ") sleeping for " + this.getTime() + "mls.");
                }
                Thread.sleep(this.getTime());
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("(" + Thread.currentThread().getName() + ") woke up.");
                }
                result.addResult(Success.INSTANCE, (IBlock)context.peek());
            }
            catch (InterruptedException e) {
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), e);
            }
        } else {
            try {
                if (this.enter) {
                    UtilIO.pressKey();
                } else {
                    JOptionPane.showMessageDialog(null, "Pause requested. Press 'Ok' to continue.");
                }
                result.addResult(Success.INSTANCE, (IBlock)context.peek());
            }
            catch (IOException e) {
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), e);
            }
        }
        return ENext.DEEP;
    }
}

