/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.flow;

import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginValue;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.runner.RunnerException;
import org.specrunner.util.UtilEvaluator;
import org.specrunner.util.UtilLog;

public class PluginWhile
extends AbstractPluginValue {
    @Override
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        Node current = context.getNode();
        Element ele = (Element)current;
        String test = ele.getAttributeValue("test");
        if (test == null) {
            test = (String)context.getByName(ele.getAttributeValue("name"));
        }
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("WHILE(" + test + ")");
        }
        if (test == null) {
            result.addResult((Status)Failure.INSTANCE, context.newBlock(current, this), new PluginException("IPlugin while missing 'test' condition or a name which reffers to a previously defined condition."));
            return ENext.SKIP;
        }
        Node base = current.copy();
        while (current.getChildCount() > 0) {
            current.getChild(0).detach();
        }
        while (this.checkCondition(test, context)) {
            Node dn = base.copy();
            while (dn.getChildCount() > 0) {
                Node child = dn.getChild(0);
                child.detach();
                ((ParentNode)current).appendChild(child);
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("CHILD()>" + child.toXML());
                }
                try {
                    context.getRunner().run(child, context, result);
                }
                catch (RunnerException e) {
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                    result.addResult((Status)Failure.INSTANCE, context.newBlock(current, this), e);
                }
            }
        }
        return ENext.SKIP;
    }

    protected boolean checkCondition(String test, IContext context) throws PluginException {
        Object tmp = UtilEvaluator.evaluate(test, context, true);
        return tmp instanceof Boolean && (Boolean)tmp != false;
    }
}

