/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.include;

import java.util.LinkedList;
import java.util.List;
import org.specrunner.SRServices;
import org.specrunner.comparators.ComparatorException;
import org.specrunner.comparators.IComparator;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.converters.ConverterException;
import org.specrunner.converters.IConverter;
import org.specrunner.parameters.IAccess;
import org.specrunner.parameters.IAccessFactory;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginTable;
import org.specrunner.plugins.core.PluginAssertion;
import org.specrunner.plugins.core.UtilPlugin;
import org.specrunner.plugins.core.elements.PluginHtml;
import org.specrunner.plugins.core.include.PluginImport;
import org.specrunner.plugins.core.var.PluginBean;
import org.specrunner.plugins.type.Undefined;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.util.UtilLog;
import org.specrunner.util.UtilString;
import org.specrunner.util.xom.CellAdapter;
import org.specrunner.util.xom.RowAdapter;
import org.specrunner.util.xom.TableAdapter;

public class PluginColumn
extends AbstractPluginTable {
    @Override
    public ActionType getActionType() {
        return Undefined.INSTANCE;
    }

    @Override
    public ENext doStart(IContext context, IResultSet result, TableAdapter tableAdapter) throws PluginException {
        Object instance = this.getObjectInstance(context, tableAdapter);
        context.saveStrict("$BEAN", instance);
        List<RowAdapter> rows = tableAdapter.getRows();
        if (rows.isEmpty()) {
            throw new PluginException("Header information missing.");
        }
        RowAdapter header = rows.get(0);
        LinkedList<String> features = new LinkedList<String>();
        LinkedList<IConverter> converters = new LinkedList<IConverter>();
        LinkedList<List<String>> args = new LinkedList<List<String>>();
        try {
            this.extractFeatures(context, header, features, converters, args);
        }
        catch (ConverterException e) {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), e);
            return ENext.DEEP;
        }
        IAccessFactory accessFactory = SRServices.get(IAccessFactory.class);
        LinkedList<IAccess> accesses = new LinkedList<IAccess>();
        for (String f : features) {
            accesses.add(accessFactory.newAccess(instance, f.replace("?", "")));
        }
        for (int i = 1; i < rows.size(); ++i) {
            RowAdapter r = rows.get(i);
            if (r.getCellsCount() != features.size()) {
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), "Number of coluns in line " + i + " is different of headers (" + features.size() + ").");
                continue;
            }
            for (int j = 0; j < features.size(); ++j) {
                Object value;
                CellAdapter c = r.getCell(j);
                try {
                    value = c.getObject(context, true, (IConverter)converters.get(j), (List)args.get(j));
                }
                catch (PluginException e) {
                    result.addResult((Status)Failure.INSTANCE, context.newBlock(c.getNode(), this), new PluginException("Invalid value for '" + c + "'.", e));
                    continue;
                }
                String feature = (String)features.get(j);
                IAccess access = (IAccess)accesses.get(j);
                if (access == null) {
                    result.addResult((Status)Failure.INSTANCE, context.newBlock(c.getNode(), this), new PluginException("Invalid access information. Not found public attribute, bean property or method named '" + feature.replace("?", "") + "' in object '" + instance.getClass() + "'."));
                    continue;
                }
                if (feature.endsWith("?")) {
                    String content;
                    Object received = null;
                    CellAdapter hd = header.getCells().get(j);
                    if (hd.hasAttribute(content = "content") && Boolean.parseBoolean(hd.getAttribute(content)) || c.hasAttribute(content) && Boolean.parseBoolean(c.getAttribute(content))) {
                        try {
                            received = access.get(instance, feature, value);
                        }
                        catch (Exception e) {
                            if (UtilLog.LOG.isDebugEnabled()) {
                                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                            }
                            result.addResult((Status)Failure.INSTANCE, context.newBlock(c.getNode(), this), new PluginException("Could not get " + feature + "(" + value + ") in '" + (instance != null ? instance.getClass() : "null") + "'.", e));
                        }
                    } else {
                        try {
                            received = access.get(instance, feature, new Object[0]);
                        }
                        catch (Exception e) {
                            if (UtilLog.LOG.isDebugEnabled()) {
                                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                            }
                            result.addResult((Status)Failure.INSTANCE, context.newBlock(c.getNode(), this), new PluginException("Could not get " + feature + " in '" + (instance != null ? instance.getClass() : "null") + "'.", e));
                        }
                    }
                    try {
                        UtilPlugin.compare(c.getNode(), PluginAssertion.INSTANCE, result, c.getComparator((IComparator)SRServices.getComparatorManager().get("string")), value, received);
                    }
                    catch (ComparatorException e) {
                        result.addResult((Status)Failure.INSTANCE, context.newBlock(c.getNode(), this), new PluginException("Could not find comparator in " + c.toString() + ".", e));
                    }
                    continue;
                }
                try {
                    access.set(instance, feature, value);
                    result.addResult(Success.INSTANCE, context.newBlock(c.getNode(), this));
                    continue;
                }
                catch (Exception e) {
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                    result.addResult((Status)Failure.INSTANCE, context.newBlock(c.getNode(), this), new PluginException("Could not set value '" + value + "' of type " + (value != null ? value.getClass() : "undefined") + " to " + feature + " in '" + (instance != null ? instance.getClass() : "null") + "'.", e));
                }
            }
        }
        return ENext.DEEP;
    }

    protected Object getObjectInstance(IContext context, TableAdapter tableAdapter) throws PluginException {
        Object instance = null;
        List<CellAdapter> captions = tableAdapter.getCaptions();
        if (captions.size() > 1) {
            throw new PluginException("Table has '" + captions.size() + "' captions. Please use only one caption tag.");
        }
        if (captions.size() > 0) {
            String className = UtilString.camelCase(captions.get(0).getValue(), true);
            for (String pkg : PluginImport.getPackages(context)) {
                try {
                    instance = this.newInstance(Class.forName(pkg + "." + className), tableAdapter);
                    break;
                }
                catch (ClassNotFoundException e) {
                    if (!UtilLog.LOG.isTraceEnabled()) continue;
                    UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (instance == null) {
            instance = PluginBean.getBean(context);
        }
        if (instance == null) {
            instance = PluginHtml.getTestInstance();
        }
        return instance;
    }

    protected Object newInstance(Class<?> type, TableAdapter table) throws PluginException {
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new PluginException("Could not create type instance.", e);
        }
        catch (IllegalAccessException e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new PluginException("Could not create access type default constructor. Class:'" + type.getName() + "'", e);
        }
    }

    protected void extractFeatures(IContext context, RowAdapter header, List<String> features, List<IConverter> converters, List<List<String>> args) throws ConverterException, PluginException {
        for (CellAdapter h : header.getCells()) {
            features.add(this.feature(h));
            converters.add(h.getConverter());
            args.add(h.getArguments());
        }
    }

    protected String feature(CellAdapter h) {
        String value = h.getValue();
        String feature = h.hasAttribute("feature") ? UtilString.camelCase(h.getAttribute("feature")) : UtilString.camelCase(value);
        if (value != null && value.trim().endsWith("?")) {
            feature = feature + "?";
        }
        return feature;
    }
}

