/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.include;

import java.util.LinkedList;
import java.util.List;
import nu.xom.Node;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginValue;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.status.Success;
import org.specrunner.util.xom.CellAdapter;
import org.specrunner.util.xom.RowAdapter;
import org.specrunner.util.xom.TableAdapter;
import org.specrunner.util.xom.UtilNode;

public class PluginImport
extends AbstractPluginValue {
    public static final String PACKAGES_NAME = "$PACKAGES";
    private String imports;
    private String[] packages;

    @Override
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public String getImports() {
        return this.imports;
    }

    public void setImports(String imports) {
        this.imports = imports;
        if (imports != null) {
            this.packages = imports.split(";");
        }
    }

    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        Node node = context.getNode();
        List<String> list = PluginImport.getPackages(context);
        if (UtilNode.isTable(node)) {
            TableAdapter tableAdapter = UtilNode.newTableAdapter(node);
            List<RowAdapter> rows = tableAdapter.getRows();
            for (RowAdapter r : rows) {
                for (CellAdapter c : r.getCells()) {
                    list.add(c.getValue());
                    result.addResult(Success.INSTANCE, context.newBlock(c.getNode(), this));
                }
            }
        } else {
            if (this.packages == null) {
                this.setImports(node.getValue());
            }
            if (this.packages != null) {
                for (String s : this.packages) {
                    list.add(s);
                }
                result.addResult(Success.INSTANCE, context.newBlock(node, this));
            }
        }
        return ENext.DEEP;
    }

    public static List<String> getPackages(IContext context) {
        LinkedList list = (LinkedList)context.getByName(PACKAGES_NAME);
        if (list == null) {
            list = new LinkedList();
            context.saveGlobal(PACKAGES_NAME, list);
        }
        return list;
    }
}

