/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.include;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.List;
import java.util.StringTokenizer;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.listeners.IListenerManager;
import org.specrunner.listeners.ISourceListener;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPlugin;
import org.specrunner.plugins.core.UtilPlugin;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.result.status.Warning;
import org.specrunner.runner.RunnerException;
import org.specrunner.source.ISource;
import org.specrunner.source.ISourceFactoryManager;
import org.specrunner.source.SourceException;
import org.specrunner.source.resource.IResourceManager;
import org.specrunner.transformer.ITransformer;
import org.specrunner.transformer.ITransformerManager;
import org.specrunner.util.UtilEvaluator;
import org.specrunner.util.UtilLog;
import org.specrunner.util.xom.UtilNode;

public class PluginInclude
extends AbstractPlugin {
    public static final String CSS_INCLUDED = "included";
    public static final String CSS_INCLUDED_FILE = "included_file";
    public static final String CSS_INCLUDED_ARGS = "included_file_args";
    public static final String CSS_INCLUDED_CONTENT = "included_content";
    private String dir;
    protected String href;
    public static final String FEATURE_DEPTH = PluginInclude.class.getName() + ".depth";
    public static final Integer DEFAULT_DEPTH = Integer.MAX_VALUE;
    protected Integer depth = DEFAULT_DEPTH;
    public static final String FEATURE_EXPANDED = PluginInclude.class.getName() + ".expanded";
    public static final Boolean DEFAULT_EXPANDED = Boolean.FALSE;
    protected Boolean expanded = null;
    public static final String FEATURE_TRANSFORMER = PluginInclude.class.getName() + ".transformer";
    protected String transformer;

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public Boolean getExpanded() {
        return this.expanded;
    }

    public void setExpanded(Boolean expanded) {
        this.expanded = expanded;
    }

    public String getTransformer() {
        return this.transformer;
    }

    public void setTransformer(String transformer) {
        this.transformer = transformer;
    }

    @Override
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    @Override
    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_DEPTH, this);
        if (this.expanded == null) {
            fm.set(FEATURE_EXPANDED, this);
        }
        if (this.transformer == null) {
            fm.set(FEATURE_TRANSFORMER, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        Node node = context.getNode();
        UtilNode.appendCss(node, "include");
        ParentNode parent = node.getParent();
        boolean isTd = UtilNode.isElement(node, "td");
        if (isTd) {
            parent = (ParentNode)node;
        }
        try {
            int failCount;
            Element ele;
            String path;
            block22: {
                URI originalHref;
                path = this.getPath(context);
                Node args = this.bindParameters(context);
                URI newHref = originalHref = new URI(path);
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("HREF>" + newHref);
                }
                ISource current = context.getCurrentSource();
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("CURRENT>" + current);
                }
                URI source = current.getURI();
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("SRC>" + source);
                }
                URI uRI = newHref = this.dir == null ? source.resolve(newHref) : newHref;
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("URI_RESOLVED>" + newHref);
                }
                ISource newSource = this.getSource(newHref);
                newSource = this.transform(newSource);
                Document document = this.getDocument(newSource);
                int nodeIndex = isTd ? parent.getChildCount() : parent.indexOf(node) + 1;
                UtilPlugin.performChildren(node, context, result);
                String id = "include_" + System.currentTimeMillis() + "_" + System.nanoTime();
                ele = (Element)node;
                ele.addAttribute(new Attribute("id", id));
                Element resultTable = new Element("div");
                resultTable.addAttribute(new Attribute("id", id + "_inc"));
                UtilNode.setIgnore((Node)resultTable);
                parent.insertChild((Node)resultTable, nodeIndex);
                Element table = new Element("table");
                UtilNode.appendCss((Node)table, CSS_INCLUDED);
                resultTable.appendChild((Node)table);
                Element trFile = new Element("tr");
                table.appendChild((Node)trFile);
                Element thFile = new Element("th");
                UtilNode.appendCss((Node)thFile, CSS_INCLUDED_FILE);
                UtilNode.setIgnore((Node)thFile);
                trFile.appendChild((Node)thFile);
                thFile.appendChild(originalHref.toString());
                thFile = new Element("th");
                UtilNode.appendCss((Node)thFile, CSS_INCLUDED_FILE);
                UtilNode.setIgnore((Node)thFile);
                trFile.appendChild((Node)thFile);
                thFile.appendChild(args);
                Element trContent = new Element("tr");
                table.appendChild((Node)trContent);
                failCount = result.countStatus(new Failure[]{Failure.INSTANCE});
                Element tdContent = new Element("td");
                tdContent.addAttribute(new Attribute("colspan", "2"));
                UtilNode.appendCss((Node)tdContent, CSS_INCLUDED_CONTENT);
                trContent.appendChild((Node)tdContent);
                if (context.getSources().size() > this.depth) {
                    tdContent.addAttribute(new Attribute("class", Warning.INSTANCE.getCssName()));
                    tdContent.appendChild((Node)new Text("Max depth of '" + this.depth + "' reached."));
                    result.addResult((Status)Warning.INSTANCE, context.newBlock(node, this), "Max depth of '" + this.depth + "' reached>" + this.toString(context) + "\n on run " + newSource);
                } else {
                    if (!context.getSources().contains(newSource)) {
                        try {
                            Node root = document.getRootElement().copy();
                            tdContent.appendChild(root);
                            context.getSources().push(newSource);
                            List<ISourceListener> listeners = SRServices.get(IListenerManager.class).filterByType(ISourceListener.class);
                            for (ISourceListener sl : listeners) {
                                sl.onBefore(newSource, context, result);
                            }
                            try {
                                context.getRunner().run(root, context, result);
                                break block22;
                            }
                            finally {
                                IResourceManager importedResources = context.getSources().peek().getManager();
                                context.getSources().pop();
                                for (ISourceListener sl : listeners) {
                                    sl.onAfter(newSource, context, result);
                                }
                                IResourceManager resources = context.getSources().peek().getManager();
                                resources.merge(importedResources);
                            }
                        }
                        catch (RunnerException e) {
                            if (UtilLog.LOG.isDebugEnabled()) {
                                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                            }
                            throw new PluginException(e);
                        }
                    }
                    tdContent.addAttribute(new Attribute("class", Warning.INSTANCE.getCssName()));
                    tdContent.appendChild((Node)new Text("Cyclic dependency."));
                    result.addResult((Status)Warning.INSTANCE, context.newBlock(node, this), "Cyclic dependency>" + this.toString(context) + "\n on run " + newSource);
                }
            }
            failCount = result.countStatus(new Failure[]{Failure.INSTANCE}) - failCount;
            if (failCount > 0) {
                UtilNode.appendCss((Node)ele, "expanded");
                result.addResult((Status)Warning.INSTANCE, context.newBlock(node, this), "Included file failed: " + path);
            } else {
                if (this.expanded == null || !this.expanded.booleanValue()) {
                    UtilNode.appendCss((Node)ele, "collapse");
                }
                result.addResult(Success.INSTANCE, context.newBlock(node, this));
            }
        }
        catch (URISyntaxException e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            result.addResult((Status)Failure.INSTANCE, context.newBlock(node, this), e);
        }
        return ENext.SKIP;
    }

    protected ISource getSource(URI newHref) throws PluginException {
        ISource newSource = null;
        try {
            newSource = SRServices.get(ISourceFactoryManager.class).newSource(newHref.toString());
        }
        catch (SourceException e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new PluginException(e);
        }
        return newSource;
    }

    protected Document getDocument(ISource newSource) throws PluginException {
        Document document = null;
        try {
            document = newSource.getDocument();
        }
        catch (SourceException e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new PluginException(e);
        }
        return document;
    }

    protected ISource transform(ISource newSource) throws PluginException {
        try {
            newSource = ((ITransformer)SRServices.get(ITransformerManager.class).getDefault()).transform(newSource);
        }
        catch (SourceException e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new PluginException(e);
        }
        if (this.transformer != null) {
            ITransformerManager itm = SRServices.get(ITransformerManager.class);
            ITransformer t = (ITransformer)itm.get(this.transformer);
            if (t == null) {
                try {
                    t = (ITransformer)Class.forName(this.transformer).newInstance();
                    itm.bind(this.transformer, t);
                }
                catch (Exception e) {
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                    throw new PluginException(e);
                }
            }
            t.initialize();
            try {
                newSource = t.transform(newSource);
            }
            catch (SourceException e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                throw new PluginException(e);
            }
        }
        return newSource;
    }

    protected Node bindParameters(IContext context) throws PluginException {
        int indexParameters = this.href.indexOf(63);
        if (indexParameters > 0) {
            String query = this.href.substring(indexParameters + 1);
            try {
                StringTokenizer st = new StringTokenizer(query, "&=");
                if (st.countTokens() % 2 != 0) {
                    throw new PluginException("The parameters are not valid. Current value:" + query);
                }
                Element args = new Element("table");
                UtilNode.appendCss((Node)args, CSS_INCLUDED_ARGS);
                UtilNode.setIgnore((Node)args);
                while (st.hasMoreTokens()) {
                    String key = URLDecoder.decode(st.nextToken(), "UTF-8");
                    String value = URLDecoder.decode(st.nextToken(), "UTF-8");
                    try {
                        String var = key;
                        Object obj = UtilEvaluator.evaluate(value, context, true);
                        context.saveLocal(var, obj);
                        Element tr = new Element("tr");
                        args.appendChild((Node)tr);
                        Element td = new Element("td");
                        args.appendChild((Node)td);
                        td.appendChild(var);
                        td = new Element("td");
                        UtilNode.setIgnore((Node)td);
                        args.appendChild((Node)td);
                        td.appendChild(String.valueOf(obj));
                    }
                    catch (Exception e) {
                        throw new PluginException("Invalid parameter (" + key + "," + value + ")", e);
                    }
                }
                return args;
            }
            catch (UnsupportedEncodingException e) {
                throw new PluginException("Unable do decode query:" + query, e);
            }
        }
        return new Text("");
    }

    protected String getPath(IContext context) throws PluginException {
        String path = this.href;
        int indexParameters = this.href.indexOf(63);
        if (indexParameters > 0) {
            path = this.href.substring(0, indexParameters);
        }
        if (this.dir != null) {
            path = this.dir + "/" + path;
        }
        return path;
    }

    protected StringBuilder toString(IContext context) {
        StringBuilder sb = new StringBuilder();
        for (ISource i : context.getSources()) {
            sb.append("\n" + i);
        }
        return sb;
    }
}

