/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.language;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.converters.UtilConverter;
import org.specrunner.junit.ExpectedMessage;
import org.specrunner.parameters.DontEval;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPlugin;
import org.specrunner.plugins.core.elements.PluginHtml;
import org.specrunner.plugins.core.language.Placeholders;
import org.specrunner.plugins.core.language.Sentence;
import org.specrunner.plugins.core.language.Synonyms;
import org.specrunner.plugins.core.var.PluginBean;
import org.specrunner.plugins.type.Assertion;
import org.specrunner.plugins.type.Command;
import org.specrunner.plugins.type.Undefined;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.util.ExceptionUtil;
import org.specrunner.util.UtilLog;
import org.specrunner.util.UtilString;
import org.specrunner.util.aligner.core.DefaultAlignmentException;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheFactory;
import org.specrunner.util.xom.INodeHolder;
import org.specrunner.util.xom.UtilNode;

public class PluginSentence
extends AbstractPlugin {
    private ActionType type = Undefined.INSTANCE;
    private String method;
    private Boolean after = Boolean.FALSE;
    protected static ICache<Class<?>, List<Method>> cacheMethods = SRServices.get(ICacheFactory.class).newCache(PluginSentence.class.getName() + "_methods");
    protected static ICache<String, Pattern> cachePatterns = SRServices.get(ICacheFactory.class).newCache(PluginSentence.class.getName() + "_patterns");

    @Override
    public ActionType getActionType() {
        return this.type;
    }

    public String getMethod() {
        return this.method;
    }

    @DontEval
    public void setMethod(String method) {
        this.method = method;
    }

    public Boolean getAfter() {
        return this.after;
    }

    public void setAfter(Boolean after) {
        this.after = after;
    }

    @Override
    public void doEnd(IContext context, IResultSet result) throws PluginException {
        Object target = this.getObject(context);
        if (target == null) {
            throw new PluginException("Target object cannot be null.");
        }
        String methodToCall = this.method;
        StringBuilder methodName = new StringBuilder();
        LinkedList<Object> arguments = new LinkedList<Object>();
        this.extractMethodNameArguments(context, target, methodName, arguments);
        if (methodToCall == null) {
            methodToCall = methodName.toString();
        }
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("FULL:" + context.getNode().toXML());
            UtilLog.LOG.debug("TEXT:" + methodName);
            UtilLog.LOG.debug("METH:" + methodToCall);
            UtilLog.LOG.debug("ARGS:" + arguments);
        }
        Throwable error = null;
        Method m = this.after != false ? this.getMethodAfter(target, methodToCall, arguments) : this.getMethodBefore(target, methodToCall, arguments);
        this.type = m.getReturnType() == Boolean.class || m.getReturnType() == Boolean.TYPE ? Assertion.INSTANCE : Command.INSTANCE;
        try {
            if (this.after.booleanValue()) {
                this.prepareArgumentsAfter(context, m, arguments);
            } else {
                this.prepareArgumentsBefore(context, m, arguments);
            }
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("TYPED ARGS[" + arguments.size() + "]:");
                for (int i = 0; i < arguments.size(); ++i) {
                    Object tmp = arguments.get(i);
                    UtilLog.LOG.debug("\t ARGS(" + i + "):" + tmp + " of type '" + (tmp != null ? tmp.getClass() : "null") + "'.");
                }
            }
            StringBuilder sb = new StringBuilder();
            Class<?>[] expectedTypes = m.getParameterTypes();
            for (int i = 0; i < expectedTypes.length; ++i) {
                Object arg = arguments.get(i);
                if (UtilConverter.getWrapper(expectedTypes[i]).isInstance(arg)) continue;
                sb.append("Method '" + m + "' expected argument[" + i + "] of type '" + expectedTypes[i].getName() + "' received '" + arg + "' of type '" + (arg == null ? "null" : arg.getClass().getName()) + "'.\n");
            }
            if (sb.length() != 0) {
                sb.setLength(sb.length() - 1);
                throw new PluginException(sb.toString());
            }
            Object tmp = m.invoke(target, arguments.toArray());
            if (this.type == Assertion.INSTANCE && tmp instanceof Boolean && !((Boolean)tmp).booleanValue()) {
                throw new PluginException("Expected result of '" + m + "' must be 'true'. Received 'false'.");
            }
            result.addResult(Success.INSTANCE, (IBlock)context.peek());
        }
        catch (IllegalArgumentException e) {
            error = e.getCause() != null ? e.getCause() : e;
        }
        catch (IllegalAccessException e) {
            error = e.getCause() != null ? e.getCause() : e;
        }
        catch (InvocationTargetException e) {
            error = e.getCause() != null ? e.getCause() : e;
        }
        catch (PluginException e) {
            error = e;
        }
        ExpectedMessage em = m.getAnnotation(ExpectedMessage.class);
        if (error != null) {
            if (em == null) {
                error = ExceptionUtil.unwrapException(error);
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), error);
                return;
            }
            String received = error.getMessage();
            String expectation = em.value();
            if (expectation.equals(received)) {
                result.addResult(Success.INSTANCE, (IBlock)context.peek());
                return;
            }
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), new DefaultAlignmentException("" + m + arguments + "\nExpected message does not match.", expectation, received));
        } else if (em != null) {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), "Expected message not received.\nMessage: " + em.value());
        }
    }

    protected Object getObject(IContext context) {
        Object instance = PluginBean.getBean(context);
        if (instance == null) {
            instance = PluginHtml.getTestInstance();
        }
        return instance;
    }

    protected void extractMethodNameArguments(IContext context, Object target, StringBuilder methodName, List<Object> arguments) throws PluginException {
        Node node = context.getNode();
        boolean onlyText = true;
        StringBuilder startText = null;
        for (int i = 0; onlyText && i < node.getChildCount(); ++i) {
            Node child = node.getChild(i);
            onlyText = child instanceof Text;
            if (!onlyText) continue;
            if (startText == null) {
                startText = new StringBuilder();
            }
            startText.append(child.getValue());
        }
        INodeHolder holder = UtilNode.newNodeHolder((Node)(onlyText ? node : new Text(startText.toString())));
        String value = String.valueOf(holder.getObject(context, true));
        boolean annotation = this.fromAnnotations(value, target, methodName, arguments);
        if (!onlyText || annotation) {
            this.onlyArgs(context, node, annotation ? new StringBuilder() : methodName, arguments);
        } else {
            this.onlyText(value, methodName, arguments);
        }
        if (!annotation) {
            String tmp = UtilString.camelCase(methodName.toString());
            methodName.setLength(0);
            methodName.append(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fromAnnotations(String value, Object target, StringBuilder text, List<Object> args) throws PluginException {
        if (this.method != null) {
            return false;
        }
        Class<?> clazz = target.getClass();
        List<Method> ms = null;
        ICache<Class<?>, List<Method>> iCache = cacheMethods;
        synchronized (iCache) {
            ms = cacheMethods.get(clazz);
            if (ms == null) {
                ms = new LinkedList<Method>();
                for (Method m : clazz.getMethods()) {
                    Sentence s = m.getAnnotation(Sentence.class);
                    if (s == null) continue;
                    ms.add(m);
                }
                cacheMethods.put(clazz, ms);
                if (UtilLog.LOG.isTraceEnabled()) {
                    UtilLog.LOG.trace("Class " + clazz + " mapped to @Sentence annotated methods: '" + ms + "'.");
                }
            } else if (UtilLog.LOG.isTraceEnabled()) {
                UtilLog.LOG.trace("Class " + clazz + " map to @Sentence reused.");
            }
        }
        for (Method m : ms) {
            Sentence s = m.getAnnotation(Sentence.class);
            LinkedList<String> strs = new LinkedList<String>();
            strs.add(s.value());
            Synonyms sm = m.getAnnotation(Synonyms.class);
            if (sm != null) {
                for (String syn : sm.value()) {
                    strs.add(syn);
                }
            }
            boolean found = false;
            for (int i = 0; i < strs.size(); ++i) {
                String str = (String)strs.get(i);
                str = this.removePlaceholders(m, str);
                Pattern pattern = null;
                ICache<String, Pattern> iCache2 = cachePatterns;
                synchronized (iCache2) {
                    pattern = cachePatterns.get(str);
                    if (pattern == null) {
                        pattern = Pattern.compile(str, i == 0 || sm == null ? s.options() : sm.options());
                        cachePatterns.put(str, pattern);
                        if (UtilLog.LOG.isTraceEnabled()) {
                            UtilLog.LOG.trace("New pattern for '" + str + "' created.");
                        }
                    } else if (UtilLog.LOG.isTraceEnabled()) {
                        UtilLog.LOG.trace("Reused pattern for '" + str + "'.");
                    }
                }
                Matcher matcher = pattern.matcher(value);
                if (!matcher.find()) continue;
                for (int j = 1; j <= matcher.groupCount(); ++j) {
                    args.add(matcher.group(j));
                }
                text.append(m.getName());
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        return text.length() != 0;
    }

    protected String removePlaceholders(Method method, String str) throws PluginException {
        Class<?>[] types = method.getParameterTypes();
        int index = 0;
        String result = str;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '$') continue;
            StringBuilder tmp = new StringBuilder("$");
            while (++i < str.length() && str.charAt(i) != ' ') {
                tmp.append(str.charAt(i));
            }
            String key = tmp.toString();
            String placeholder = (String)Placeholders.get().get(key);
            if (placeholder == null) {
                String replacement = "$" + types[index].getSimpleName().toLowerCase();
                placeholder = (String)Placeholders.get().get(replacement);
                if (placeholder == null) {
                    throw new PluginException("On placeholder '" + key + "' resolution, none pattern found for '" + replacement + "'.");
                }
                result = result.replace(key, placeholder);
            }
            result = result.replace(key, placeholder);
            ++index;
        }
        return result;
    }

    protected void onlyText(String text, StringBuilder methodName, List<Object> arguments) {
        Stack<StringBuilder> stack = new Stack<StringBuilder>();
        stack.push(new StringBuilder());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\"') {
                if (i > 0 && text.charAt(i - 1) == '\\') {
                    ((StringBuilder)stack.peek()).setLength(((StringBuilder)stack.peek()).length() - 1);
                    ((StringBuilder)stack.peek()).append(c);
                    continue;
                }
                if (stack.size() == 1) {
                    stack.push(new StringBuilder());
                    continue;
                }
                arguments.add(((StringBuilder)stack.pop()).toString());
                continue;
            }
            ((StringBuilder)stack.peek()).append(c);
        }
        methodName.append(((StringBuilder)stack.pop()).toString());
    }

    protected void onlyArgs(IContext context, Node node, StringBuilder text, List<Object> args) throws PluginException {
        if (node instanceof Text) {
            text.append(node.getValue());
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node n = node.getChild(i);
            if (n instanceof Element) {
                INodeHolder h = UtilNode.newNodeHolder(n);
                if (h.hasName("arg") || h.attributeContains("class", "arg")) {
                    args.add(h.getObject(context, true));
                    continue;
                }
                this.onlyArgs(context, n, text, args);
                continue;
            }
            this.onlyArgs(context, n, text, args);
        }
    }

    protected Method getMethodBefore(Object target, String method, List<Object> args) throws PluginException {
        Method[] methods;
        Class<?> clazz = target.getClass();
        for (Method m : methods = clazz.getMethods()) {
            if (!m.getName().equals(method) || m.getParameterTypes().length != args.size()) continue;
            return m;
        }
        throw new PluginException("Method named '" + method + "' with " + args.size() + " parameter(s) not found for " + clazz + ".\n Another reason to this error show up is when you have defined a wrong regular expression for the target method you expected to call [Check @Sentence and @Synonyms annotations].");
    }

    protected void prepareArgumentsBefore(IContext context, Method method, List<Object> arguments) throws PluginException {
        UtilConverter.prepareMethodArguments(method, arguments);
    }

    protected Method getMethodAfter(Object target, String method, List<Object> args) throws PluginException {
        Class<?> type = target.getClass();
        Class[] types = new Class[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            Object tmp = args.get(i);
            types[i] = tmp != null ? tmp.getClass() : Object.class;
        }
        try {
            return type.getMethod(method, types);
        }
        catch (SecurityException e) {
            throw new PluginException(e);
        }
        catch (NoSuchMethodException e) {
            throw new PluginException(e);
        }
    }

    protected void prepareArgumentsAfter(IContext context, Method method, List<Object> arguments) throws PluginException {
    }
}

