/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.logical;

import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.SpecRunnerException;
import org.specrunner.comparators.IComparator;
import org.specrunner.context.IContext;
import org.specrunner.expressions.Unsilent;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginDual;
import org.specrunner.plugins.type.Assertion;
import org.specrunner.util.aligner.core.DefaultAlignmentException;
import org.specrunner.util.xom.INodeHolder;
import org.specrunner.util.xom.UtilNode;

public class PluginEquals
extends AbstractPluginDual {
    protected Throwable error;

    @Override
    public ActionType getActionType() {
        return Assertion.INSTANCE;
    }

    @Override
    @Unsilent
    public void setValue(Object value) {
        super.setValue(value);
    }

    @Override
    protected boolean operation(Object obj, IContext context) throws PluginException {
        Node node = context.getNode();
        INodeHolder parent = UtilNode.newNodeHolder(node);
        Object objExpected = null;
        Object objReceived = null;
        if (node instanceof Element) {
            if (parent.hasAttribute("value") || parent.hasAttribute("property")) {
                Object tmp = parent.getObject(context, false);
                if (obj instanceof String) {
                    objExpected = this.getNormalized(String.valueOf(obj));
                    objReceived = this.getNormalized(String.valueOf(tmp));
                } else {
                    objExpected = obj;
                    objReceived = tmp;
                }
            } else {
                objExpected = UtilNode.newNodeHolder(UtilNode.getLeft(node)).getObject(context, true);
                objReceived = UtilNode.newNodeHolder(UtilNode.getRight(node)).getObject(context, true);
            }
        }
        try {
            return this.verify(context, parent.getComparator(), objExpected, objReceived);
        }
        catch (SpecRunnerException e) {
            throw new PluginException(e);
        }
    }

    protected boolean verify(IContext context, IComparator comparator, Object expected, Object received) throws SpecRunnerException {
        boolean result = comparator.match(expected, received);
        if (!result) {
            this.error = expected instanceof String && received instanceof String ? new DefaultAlignmentException(expected.toString(), received.toString()) : new PluginException("Values are different. Expected: '" + expected + "', Received: '" + received + "'. \n" + (context.hasNode() ? "Node:" + context.getNode().toXML() : "Plugin:" + context.getPlugin()));
        }
        return result;
    }

    @Override
    protected Throwable getError() {
        return this.error;
    }
}

