/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.logical;

import java.util.Iterator;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.expressions.Unsilent;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginValue;
import org.specrunner.plugins.core.UtilPlugin;
import org.specrunner.plugins.type.Assertion;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.util.UtilEvaluator;
import org.specrunner.util.xom.UtilNode;

public class PluginVerifyRows
extends AbstractPluginValue {
    public PluginVerifyRows() {
        this.setName("item");
    }

    @Override
    @Unsilent
    public void setValue(Object value) {
        super.setValue(value);
    }

    @Override
    public ActionType getActionType() {
        return Assertion.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        int j;
        int i;
        Object value = this.getValue();
        if (!(value instanceof Iterable)) {
            throw new PluginException("Value is null or not found, or value has an invalid type (should be an Iterable).");
        }
        Iterator ite = ((Iterable)value).iterator();
        Node node = context.getNode();
        Nodes ns = node.query("descendant::tr");
        if (ns.size() == 0) {
            throw new PluginException("Missing rows.");
        }
        Element head = (Element)ns.get(0);
        Nodes hs = head.query("descendant::th");
        if (hs.size() == 0) {
            throw new PluginException("Missing header information.");
        }
        UtilNode.setIgnore((Node)head);
        IBlock block = (IBlock)context.peek();
        String pos = "index";
        boolean first = true;
        for (i = 1; i < ns.size(); ++i) {
            Element row = (Element)ns.get(i);
            Nodes cs = row.query("descendant::td");
            if (hs.size() != cs.size()) {
                throw new PluginException("Number of headers (" + hs.size() + ") is different of columns (" + cs.size() + ").");
            }
            for (j = 0; j < cs.size(); ++j) {
                Element h = (Element)hs.get(j);
                Element c = (Element)cs.get(j);
                for (int k = 0; k < h.getAttributeCount(); ++k) {
                    Attribute att = h.getAttribute(k);
                    c.addAttribute((Attribute)att.copy());
                }
            }
            context.push(context.newBlock((Node)row, this));
            try {
                context.saveLocal(pos, String.valueOf(i - 1));
                if (ite.hasNext()) {
                    context.saveLocal(this.getName(), ite.next());
                    UtilPlugin.performChildren((Node)row, context, result);
                    continue;
                }
                if (!first) continue;
                result.addResult((Status)Failure.INSTANCE, block, new PluginException("Returned enumeration missing itens."));
                first = false;
                continue;
            }
            finally {
                context.clearLocal(this.getName());
                context.clearLocal(pos);
                context.pop();
            }
        }
        Element ele = (Element)node;
        first = true;
        while (ite.hasNext()) {
            if (first) {
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), new PluginException("Returned enumeration has more elements than expected."));
                first = false;
            }
            Element tr = new Element("tr");
            for (j = 0; j < hs.size(); ++j) {
                Element td = new Element("td");
                td.appendChild(UtilEvaluator.asExpression(((Element)hs.get(j)).getAttributeValue("value")));
                tr.appendChild((Node)td);
            }
            ele.appendChild((Node)tr);
            try {
                context.push(context.newBlock((Node)tr, this));
                context.saveLocal(pos, String.valueOf(i - 1));
                context.saveLocal(this.getName(), ite.next());
                UtilPlugin.performChildren((Node)tr, context, result);
            }
            finally {
                context.clearLocal(this.getName());
                context.clearLocal(pos);
                context.pop();
            }
            ++i;
        }
        return ENext.SKIP;
    }
}

