/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.macro;

import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginNamed;
import org.specrunner.plugins.core.UtilPlugin;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;

public class PluginCall
extends AbstractPluginNamed {
    public static final String CSS_CALLED = "called";

    @Override
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        String macroName;
        Object obj;
        Node node = context.getNode();
        UtilPlugin.performChildren(node, context, result);
        String name = this.getName();
        if (name == null) {
            this.setName(node.getValue());
        }
        if ((obj = context.getByName(macroName = this.getName())) == null) {
            throw new PluginException("Macro named '" + macroName + "' not found.");
        }
        if (!(obj instanceof Node)) {
            throw new PluginException("Object with name '" + macroName + "' is not a macro.");
        }
        ParentNode parent = node.getParent();
        int index = parent.indexOf(node);
        Node macro = (Node)obj;
        for (int i = 0; i < macro.getChildCount(); ++i) {
            parent.insertChild(macro.getChild(i).copy(), ++index);
        }
        Element ele = (Element)node;
        ele.addAttribute(new Attribute("name", macroName));
        ele.addAttribute(new Attribute("class", ele.getAttributeValue("class") + " " + CSS_CALLED));
        return ENext.DEEP;
    }
}

