/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.macro;

import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginScoped;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Warning;
import org.specrunner.util.xom.UtilNode;

public class PluginMacro
extends AbstractPluginScoped {
    public static final String CSS_DEFINED = "macro_defined";
    private boolean run;
    private boolean global;

    public boolean isRun() {
        return this.run;
    }

    public void setRun(boolean run) {
        this.run = run;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    @Override
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        String macroName = this.getName();
        Object macro = context.getByName(macroName);
        if (macro != null) {
            result.addResult((Status)Warning.INSTANCE, (IBlock)context.peek(), "Macro name already used in '" + (macro instanceof Node ? ((Node)macro).toXML() : macro) + "'.");
        }
        Element ele = (Element)context.getNode();
        if (this.isGlobal()) {
            this.saveGlobal(context, macroName, ele.copy());
        } else {
            this.saveLocal(context, macroName, ele.copy());
        }
        UtilNode.appendCss((Node)ele, CSS_DEFINED);
        return this.run ? ENext.DEEP : ENext.SKIP;
    }
}

