/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.objects;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.apache.commons.beanutils.PropertyUtils;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.converters.ConverterException;
import org.specrunner.converters.IConverter;
import org.specrunner.parameters.DontEval;
import org.specrunner.parameters.IParameterHolder;
import org.specrunner.parameters.core.UtilParametrized;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginTable;
import org.specrunner.plugins.core.objects.IObjectCreator;
import org.specrunner.plugins.core.objects.PluginObjectManager;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.result.status.Warning;
import org.specrunner.source.ISource;
import org.specrunner.source.ISourceFactoryManager;
import org.specrunner.source.SourceException;
import org.specrunner.util.UtilEvaluator;
import org.specrunner.util.UtilLog;
import org.specrunner.util.UtilString;
import org.specrunner.util.xom.CellAdapter;
import org.specrunner.util.xom.RowAdapter;
import org.specrunner.util.xom.TableAdapter;
import org.specrunner.util.xom.UtilNode;

public abstract class AbstractPluginObject
extends AbstractPluginTable {
    protected String type;
    protected Class<?> typeInstance;
    protected String creator;
    protected IObjectCreator creatorInstance;
    protected String reference;
    protected List<String> references = new LinkedList<String>();
    protected String separator;
    protected String mapping;
    protected Map<String, Field> generic = new HashMap<String, Field>();
    protected List<Field> fields = new LinkedList<Field>();
    protected Map<String, String> keysBefore = new HashMap<String, String>();
    protected Map<String, Object> instances = new HashMap<String, Object>();

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Class<?> getTypeInstance() {
        return this.typeInstance;
    }

    public void setTypeInstance(Class<?> typeInstance) {
        this.typeInstance = typeInstance;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public IObjectCreator getCreatorInstance() {
        return this.creatorInstance;
    }

    public void setCreatorInstance(IObjectCreator creatorInstance) {
        this.creatorInstance = creatorInstance;
    }

    public String getReference() {
        return this.reference;
    }

    @DontEval
    public void setReference(String reference) {
        this.reference = reference;
        if (reference != null) {
            String[] refs;
            this.references.clear();
            for (String s : refs = reference.split(",")) {
                this.references.add(s);
            }
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    @Override
    public void initialize(IContext context, TableAdapter table) throws PluginException {
        super.initialize(context, table);
        if (this.mapping != null) {
            this.loadMapping(context, table);
        } else {
            this.setObjectInformation();
        }
    }

    protected void loadMapping(IContext context, TableAdapter table) throws PluginException {
        try {
            ISource source;
            Document doc;
            Nodes ns;
            URL file;
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Loading object mapping>" + this.mapping);
            }
            if ((file = this.getClass().getResource(this.mapping)) == null) {
                throw new PluginException("The object mapping file '" + this.mapping + "' not found.");
            }
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Loading object mapping file>" + file);
            }
            if ((ns = (doc = (source = SRServices.get(ISourceFactoryManager.class).newSource(file.toString())).getDocument()).query("//table")).size() == 0) {
                throw new PluginException("The mapping file must have a table element with the field information.");
            }
            Element n = (Element)ns.get(0);
            TableAdapter ta = UtilNode.newTableAdapter((Node)n);
            if (ta.getRowCount() == 0) {
                throw new PluginException("The mapping file might have at least one row (usually a header) with the generic field information.");
            }
            RowAdapter information = ta.getRow(0);
            UtilParametrized.setProperties(context, (IParameterHolder)this, n);
            UtilParametrized.setProperties(context, (IParameterHolder)this, (Element)table.getNode());
            this.setObjectInformation();
            LinkedList<Field> general = new LinkedList<Field>();
            this.loadFields(context, information, general);
            for (Field field : general) {
                this.generic.put(field.getFieldName(), field);
            }
        }
        catch (SourceException e) {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info(e.getMessage(), (Throwable)e);
            }
            throw new PluginException("Fail on loading mapping information: '" + this.mapping + "'.", e);
        }
    }

    protected void setObjectInformation() throws PluginException {
        try {
            if (this.type != null) {
                this.typeInstance = Class.forName(this.type);
            }
            if (this.creator != null) {
                this.creatorInstance = (IObjectCreator)Class.forName(this.creator).newInstance();
            }
        }
        catch (Exception e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new PluginException(e);
        }
        if (this.typeInstance == null) {
            throw new PluginException("Set 'type' with object class name.");
        }
    }

    @Override
    public void doEnd(IContext context, IResultSet result, TableAdapter table) throws PluginException {
        if (this.isMapped()) {
            PluginObjectManager.get().bind(this);
        }
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (i == 0) {
                try {
                    this.loadFields(context, table.getRow(i), this.fields);
                    result.addResult(Success.INSTANCE, context.newBlock(table.getRow(i).getNode(), this));
                    continue;
                }
                catch (Exception e) {
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                    result.addResult((Status)Failure.INSTANCE, context.newBlock(table.getRow(i).getNode(), this), e);
                    break;
                }
            }
            try {
                this.processLine(context, table.getRow(i), result);
                continue;
            }
            catch (Exception e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                result.addResult((Status)Failure.INSTANCE, context.newBlock(table.getRow(i).getNode(), this), e);
            }
        }
    }

    protected void loadFields(IContext context, RowAdapter row, List<Field> list) throws PluginException {
        int index = 0;
        for (CellAdapter cell : row.getCells()) {
            boolean ignore = false;
            if (cell.hasAttribute("ignore")) {
                ignore = Boolean.parseBoolean(cell.getAttribute("ignore"));
            }
            String fieldName = cell.getValue().trim();
            String name = cell.hasAttribute("field") ? cell.getAttribute("field") : UtilString.camelCase(fieldName);
            Field f = this.generic.get(fieldName);
            if (f == null) {
                f = new Field();
                f.setFieldName(fieldName);
            } else {
                name = f.getFullName();
            }
            f.setIndex(index++);
            f.setReference(this.references.contains(name));
            f.setIgnore(ignore);
            if (!ignore) {
                String comparator;
                String[] converters;
                StringTokenizer st = new StringTokenizer(name, ".");
                String[] names = new String[st.countTokens()];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = st.nextToken();
                }
                if (names.length > 0) {
                    f.setNames(names);
                }
                Class[] types = new Class[names.length];
                Class currentType = this.typeInstance;
                for (int i = 0; currentType != null && i < types.length; ++i) {
                    Method m;
                    block21: {
                        m = null;
                        try {
                            m = currentType.getMethod("get" + Character.toUpperCase(names[i].charAt(0)) + names[i].substring(1), new Class[0]);
                        }
                        catch (Exception e) {
                            try {
                                m = currentType.getMethod("is" + Character.toUpperCase(names[i].charAt(0)) + names[i].substring(1), new Class[0]);
                            }
                            catch (Exception e1) {
                                if (!UtilLog.LOG.isDebugEnabled()) break block21;
                                UtilLog.LOG.debug(e1.getMessage(), (Throwable)e1);
                            }
                        }
                    }
                    if (m == null) {
                        throw new PluginException("Getter method for " + names[i] + " not found for type '" + currentType + "'.");
                    }
                    types[i] = m.getReturnType();
                    currentType = types[i];
                }
                if (types.length > 0) {
                    f.setTypes(types);
                }
                String def = null;
                if (cell.hasAttribute("default")) {
                    def = cell.getAttribute("default");
                }
                if (def != null) {
                    f.setDef(def);
                }
                String converter = cell.hasAttribute("converter") ? cell.getAttribute("converter") : null;
                String[] stringArray = converters = converter != null ? converter.split(",") : new String[]{};
                if (f.getConverters() == null || converters.length > 0) {
                    f.setConverters(converters);
                }
                int i = 0;
                LinkedList<Object> args = new LinkedList<Object>();
                while (cell.hasAttribute("arg" + i)) {
                    args.add(UtilEvaluator.evaluate(cell.getAttribute("arg" + i), context, true));
                    ++i;
                }
                if (f.getArgs() == null || !args.isEmpty()) {
                    f.setArgs(args.toArray(new String[args.size()]));
                }
                String string = comparator = cell.hasAttribute("comparator") ? cell.getAttribute("comparator") : null;
                if (comparator != null) {
                    f.setComparator(comparator);
                }
            }
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("FIELD>" + f);
            }
            list.add(f);
        }
    }

    protected abstract boolean isMapped();

    protected void processLine(IContext context, RowAdapter row, IResultSet result) throws Exception {
        Object instance = this.create(row);
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("CREATE:" + instance);
        }
        if (this.populate(instance, context, row, result)) {
            Object obj;
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("POPULATE:" + instance);
            }
            String keyBefore = this.makeKey(instance);
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("KEYBEFORE:" + keyBefore);
            }
            if ((obj = this.instances.get(this.keysBefore.get(keyBefore))) != null && this.isMapped()) {
                result.addResult((Status)Failure.INSTANCE, context.newBlock(row.getNode(), this), new PluginException("Key '" + keyBefore + "' already used by :" + obj));
                for (CellAdapter cell : row.getCells()) {
                    String title = cell.hasAttribute("title") ? cell.getAttribute("title") : "|";
                    String old = title.substring(0, title.lastIndexOf(124));
                    if (old.isEmpty()) {
                        cell.removeAttribute("title");
                        continue;
                    }
                    cell.setAttribute("title", old);
                }
            } else {
                this.action(context, instance, row, result);
                if (this.isMapped()) {
                    String keyAfter = this.makeKey(instance);
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug("KEYAFTER:" + keyAfter);
                    }
                    this.mapObject(instance, keyBefore, keyAfter);
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug("SAVE:" + this.keysBefore);
                        UtilLog.LOG.debug("INST:" + this.instances);
                    }
                    result.addResult(Success.INSTANCE, context.newBlock(row.getNode(), this));
                }
            }
        }
    }

    protected Object create(RowAdapter row) throws Exception {
        Object result = null;
        if (this.creator != null) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("CREATOR_ROW(" + row + ")");
            }
            result = this.creatorInstance.create(this.typeInstance, row);
        }
        if (result == null) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("NEW_INSTANCE_ROW(" + row + ")");
            }
            result = this.typeInstance.newInstance();
        }
        return result;
    }

    protected boolean populate(Object instance, IContext context, RowAdapter row, IResultSet result) throws Exception {
        boolean ok = true;
        for (int i = 0; i < this.fields.size(); ++i) {
            CellAdapter cell = row.getCell(i);
            try {
                Class<?> t;
                Field f = this.fields.get(i);
                if (f.isIgnore()) continue;
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("ON>" + f.getFullName());
                }
                String text = cell.getValue();
                Object value = text;
                if (text.isEmpty()) {
                    value = UtilEvaluator.evaluate(f.def, context, true);
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug("USING_DEFAULT>" + value);
                    }
                }
                if (!(t = f.getTypes()[f.getTypes().length - 1]).isInstance(value)) {
                    String[] convs = f.converters;
                    if (cell.hasAttribute("converter")) {
                        convs = cell.getAttribute("converter").split(",");
                    }
                    for (int j = 0; j < convs.length; ++j) {
                        IConverter con = (IConverter)SRServices.getConverterManager().get(convs[j]);
                        if (con == null) {
                            throw new ConverterException("Converter named '" + convs[j] + "' not found.");
                        }
                        value = con.convert(value, f.args);
                    }
                }
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("VALUE>" + value);
                }
                this.setValue(row, instance, f, value);
                String title = cell.hasAttribute("title") ? cell.getAttribute("title") : "";
                cell.setAttribute("title", title + "|toString()=" + PropertyUtils.getProperty((Object)instance, (String)f.getFullName()));
                continue;
            }
            catch (Exception e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                result.addResult((Status)Failure.INSTANCE, context.newBlock(cell.getNode(), this), e);
                ok = false;
            }
        }
        if (!ok) {
            result.addResult((Status)Warning.INSTANCE, context.newBlock(row.getNode(), this), "Could not create instance.");
        }
        return ok;
    }

    protected void setValue(RowAdapter row, Object instance, Field f, Object value) throws Exception {
        Object current = instance;
        for (int i = 0; i < f.names.length - 1; ++i) {
            Object tmp = PropertyUtils.getProperty((Object)current, (String)f.names[i]);
            if (tmp == null) {
                if (this.creator != null) {
                    tmp = this.creatorInstance.create(f.types[i], row);
                }
                if (tmp == null) {
                    tmp = f.types[i].newInstance();
                }
                PropertyUtils.setProperty((Object)current, (String)f.names[i], (Object)tmp);
            }
            current = tmp;
        }
        if (value == null) {
            this.setObject(instance, f, null);
        } else {
            Class<?> st = f.getSpecificType();
            if (st == Boolean.TYPE || st == Boolean.class) {
                this.setBoolean(instance, f, value);
            } else if (st == Character.TYPE || st == Character.class) {
                this.setChar(instance, f, value);
            } else if (st == Short.TYPE || st == Short.class) {
                this.setShort(instance, f, value);
            } else if (st == Integer.TYPE || st == Integer.class) {
                this.setInteger(instance, f, value);
            } else if (st == Long.TYPE || st == Long.class) {
                this.setLong(instance, f, value);
            } else if (st == Float.TYPE || st == Float.class) {
                this.setFloat(instance, f, value);
            } else if (st == Double.TYPE || st == Double.class) {
                this.setDouble(instance, f, value);
            } else if (PluginObjectManager.get().isBound(st)) {
                this.setEntity(instance, f, value);
            } else {
                this.setObject(instance, f, value);
            }
        }
    }

    protected void setBoolean(Object instance, Field f, Object value) throws Exception {
        PropertyUtils.setProperty((Object)instance, (String)f.getFullName(), (Object)Boolean.valueOf(String.valueOf(value)));
    }

    protected void setChar(Object instance, Field f, Object value) throws Exception {
        PropertyUtils.setProperty((Object)instance, (String)f.getFullName(), (Object)Character.valueOf(String.valueOf(value).charAt(0)));
    }

    protected void setShort(Object instance, Field f, Object value) throws Exception {
        PropertyUtils.setProperty((Object)instance, (String)f.getFullName(), (Object)Short.valueOf(String.valueOf(value)));
    }

    protected void setInteger(Object instance, Field f, Object value) throws Exception {
        PropertyUtils.setProperty((Object)instance, (String)f.getFullName(), (Object)Integer.valueOf(String.valueOf(value)));
    }

    protected void setLong(Object instance, Field f, Object value) throws Exception {
        PropertyUtils.setProperty((Object)instance, (String)f.getFullName(), (Object)Long.valueOf(String.valueOf(value)));
    }

    protected void setFloat(Object instance, Field f, Object value) throws Exception {
        PropertyUtils.setProperty((Object)instance, (String)f.getFullName(), (Object)Float.valueOf(String.valueOf(value)));
    }

    protected void setDouble(Object instance, Field f, Object value) throws Exception {
        PropertyUtils.setProperty((Object)instance, (String)f.getFullName(), (Object)Double.valueOf(String.valueOf(value)));
    }

    protected void setEntity(Object instance, Field f, Object value) throws Exception {
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("LOOKUP(" + f.getSpecificType() + ")");
        }
        Object obj = PluginObjectManager.get().lookup(f.getSpecificType(), String.valueOf(value));
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("FOUND(" + obj + ")");
        }
        PropertyUtils.setProperty((Object)instance, (String)f.getFullName(), (Object)obj);
    }

    protected void setObject(Object instance, Field f, Object value) throws Exception {
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("OBJECT(" + f.getSpecificType() + ")");
        }
        PropertyUtils.setProperty((Object)instance, (String)f.getFullName(), (Object)value);
    }

    protected abstract void action(IContext var1, Object var2, RowAdapter var3, IResultSet var4) throws Exception;

    public String makeKey(Object instance) throws Exception {
        StringBuilder str = new StringBuilder("");
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("KEYS>" + this.reference);
        }
        for (int i = 0; i < this.references.size(); ++i) {
            str.append((i == 0 ? "" : this.separator) + PropertyUtils.getProperty((Object)instance, (String)this.references.get(i)));
        }
        return str.toString();
    }

    public void mapObject(Object instance, String keyBefore, String keyAfter) {
        this.keysBefore.put(keyBefore, keyAfter);
        this.instances.put(keyAfter, instance);
    }

    public AbstractPluginObject merge(AbstractPluginObject old) {
        this.keysBefore.putAll(old.keysBefore);
        this.instances.putAll(old.instances);
        return this;
    }

    public Object getObject(String key) throws PluginException {
        Object result = this.instances.get(this.keysBefore.get(key));
        if (result == null) {
            throw new PluginException("Instance '" + key + "' of '" + this.typeInstance.getName() + "' not found.");
        }
        return result;
    }

    public Object removeObject(String key) throws PluginException {
        Object old = this.keysBefore.get(key);
        this.keysBefore.remove(key);
        if (old == null) {
            throw new PluginException("Instance '" + key + "' of '" + this.typeInstance.getName() + "' not found.");
        }
        old = this.instances.get(old);
        this.instances.remove(old);
        if (old == null) {
            throw new PluginException("Instance '" + key + "' of '" + this.typeInstance.getName() + "' not found.");
        }
        return old;
    }

    public static class Field {
        private int index;
        private boolean ignore;
        private boolean reference;
        private String fieldName;
        private String[] names;
        private Class<?>[] types;
        private String def;
        private String[] converters;
        private String[] args;
        private String comparator;

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean isIgnore() {
            return this.ignore;
        }

        public void setIgnore(boolean ignore) {
            this.ignore = ignore;
        }

        public boolean isReference() {
            return this.reference;
        }

        public void setReference(boolean reference) {
            this.reference = reference;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String[] getNames() {
            return this.names;
        }

        public void setNames(String[] names) {
            this.names = names == null ? null : Arrays.copyOf(names, names.length);
        }

        public Class<?>[] getTypes() {
            return this.types;
        }

        public void setTypes(Class<?>[] types) {
            this.types = types == null ? null : Arrays.copyOf(types, types.length);
        }

        public String getDef() {
            return this.def;
        }

        public void setDef(String def) {
            this.def = def;
        }

        public String[] getConverters() {
            return this.converters;
        }

        public void setConverters(String[] converters) {
            this.converters = converters == null ? null : Arrays.copyOf(converters, converters.length);
        }

        public String[] getArgs() {
            return this.args;
        }

        public void setArgs(String[] args) {
            this.args = args == null ? null : Arrays.copyOf(args, args.length);
        }

        public String getComparator() {
            return this.comparator;
        }

        public void setComparator(String comparator) {
            this.comparator = comparator;
        }

        public String getFullName() {
            StringBuilder strNames = new StringBuilder("");
            for (int i = 0; i < this.names.length; ++i) {
                strNames.append(i == 0 ? "" : ".");
                strNames.append(this.names[i]);
            }
            return strNames.toString();
        }

        public Class<?> getSpecificType() {
            return this.types[this.types.length - 1];
        }

        public String toString() {
            StringBuilder strNames = new StringBuilder("");
            for (int i = 0; this.names != null && i < this.names.length; ++i) {
                strNames.append((i == 0 ? "" : ",") + this.names[i]);
            }
            StringBuilder strTypes = new StringBuilder("");
            for (int i = 0; this.types != null && i < this.types.length; ++i) {
                strTypes.append((i == 0 ? "" : ",") + this.types[i]);
            }
            StringBuilder strConvs = new StringBuilder("");
            for (int i = 0; this.converters != null && i < this.converters.length; ++i) {
                strConvs.append((i == 0 ? "" : ",") + this.converters[i]);
            }
            StringBuilder strArgs = new StringBuilder("");
            for (int i = 0; this.args != null && i < this.args.length; ++i) {
                strArgs.append((i == 0 ? "" : ",") + this.args[i]);
            }
            return this.index + ",'" + this.fieldName + "'(" + this.ignore + ")," + strNames + "( default '" + this.def + "')," + strTypes + ",[" + strConvs + "],[" + strArgs + "],(" + this.comparator + ")";
        }
    }
}

