/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.objects;

import org.apache.commons.beanutils.PropertyUtils;
import org.specrunner.SRServices;
import org.specrunner.comparators.IComparator;
import org.specrunner.comparators.IComparatorManager;
import org.specrunner.context.IContext;
import org.specrunner.plugins.core.objects.AbstractPluginObject;
import org.specrunner.plugins.core.objects.AbstractPluginObjectSelectUnique;
import org.specrunner.plugins.core.objects.IObjectSelector;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.util.aligner.core.DefaultAlignmentException;
import org.specrunner.util.xom.CellAdapter;
import org.specrunner.util.xom.RowAdapter;

public abstract class AbstractPluginObjectCompare<T>
extends AbstractPluginObjectSelectUnique<T> {
    public AbstractPluginObjectCompare(IObjectSelector<T> selector) {
        super(selector);
    }

    @Override
    public void perform(IContext context, Object base, Object instance, RowAdapter row, IResultSet result) throws Exception {
        for (AbstractPluginObject.Field f : this.fields) {
            if (f.isIgnore()) continue;
            Object currentInstance = instance;
            for (int i = 0; i < f.getNames().length && (currentInstance = PropertyUtils.getProperty((Object)currentInstance, (String)f.getNames()[i])) != null; ++i) {
            }
            Object currentBase = base;
            for (int i = 0; i < f.getNames().length && (currentBase = PropertyUtils.getProperty((Object)currentBase, (String)f.getNames()[i])) != null; ++i) {
            }
            IComparatorManager cf = SRServices.getComparatorManager();
            IComparator comparator = null;
            CellAdapter cell = row.getCell(f.getIndex());
            if (cell.hasAttribute("comparator")) {
                comparator = (IComparator)cf.get(cell.getAttribute("comparator"));
            }
            if (comparator == null && f.getComparator() != null) {
                comparator = (IComparator)cf.get(f.getComparator());
            }
            if (comparator == null && currentInstance != null) {
                Class<?> type = currentInstance.getClass();
                comparator = cf.get(type);
            }
            if (comparator == null) {
                comparator = (IComparator)cf.getDefault();
            }
            if (comparator.match(currentInstance, currentBase)) {
                result.addResult(Success.INSTANCE, context.newBlock(row.getCell(f.getIndex()).getNode(), this));
                continue;
            }
            result.addResult((Status)Failure.INSTANCE, context.newBlock(row.getCell(f.getIndex()).getNode(), this), new DefaultAlignmentException(String.valueOf(currentInstance), String.valueOf(currentBase)));
        }
    }
}

