/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.objects;

import java.util.List;
import org.specrunner.context.IContext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.objects.AbstractPluginObjectSelect;
import org.specrunner.plugins.core.objects.IObjectSelector;
import org.specrunner.result.IResultSet;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Warning;
import org.specrunner.util.xom.RowAdapter;

public abstract class AbstractPluginObjectSelectUnique<T>
extends AbstractPluginObjectSelect<T> {
    public AbstractPluginObjectSelectUnique(IObjectSelector<T> selector) {
        super(selector);
    }

    @Override
    public void processList(IContext context, Object instance, RowAdapter row, IResultSet result, List<Object> list) throws Exception {
        if (list.isEmpty()) {
            this.addError(context, row, result, new PluginException("None element found. XML:" + row.getNode().toXML()));
            return;
        }
        if (list.size() > 1) {
            this.addError(context, row, result, new PluginException("More than one element found. XML:" + row.getNode().toXML()));
            return;
        }
        Object base = list.get(0);
        if (base == null) {
            this.addError(context, row, result, new PluginException("This item is not present in object repository. XML:" + row.getNode().toXML()));
        } else {
            this.perform(context, base, instance, row, result);
        }
    }

    protected void addError(IContext context, RowAdapter row, IResultSet result, Exception e) {
        for (int i = 0; i < row.getCellsCount(); ++i) {
            result.addResult(i == 0 ? Failure.INSTANCE : Warning.INSTANCE, context.newBlock(row.getCell(i).getNode(), this), i == 0 ? e : null);
        }
    }

    public abstract void perform(IContext var1, Object var2, Object var3, RowAdapter var4, IResultSet var5) throws Exception;
}

