/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.objects;

import java.util.HashMap;
import java.util.Map;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.objects.AbstractPluginObject;
import org.specrunner.util.UtilLog;

public class PluginObjectManager {
    private static ThreadLocal<PluginObjectManager> instance = new ThreadLocal<PluginObjectManager>(){

        @Override
        protected PluginObjectManager initialValue() {
            return new PluginObjectManager();
        }
    };
    protected Map<Class<?>, AbstractPluginObject> entities = new HashMap();

    public static PluginObjectManager get() {
        return instance.get();
    }

    public void clear() {
        this.entities.clear();
    }

    public boolean isBound(Class<?> clazz) {
        return this.entities.containsKey(clazz);
    }

    public void bind(AbstractPluginObject input) {
        AbstractPluginObject old = this.entities.get(input.getTypeInstance());
        if (old == null) {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Plugin " + input.getTypeInstance() + " is new.");
            }
            this.entities.put(input.getTypeInstance(), input);
        } else {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Plugin " + input.getTypeInstance() + " merge.");
            }
            this.entities.put(input.getTypeInstance(), input.merge(old));
        }
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Plugin of " + input.getTypeInstance() + " bound.");
        }
    }

    public Object lookup(Class<?> clazz, String key) throws PluginException {
        AbstractPluginObject map = this.entities.get(clazz);
        if (map == null) {
            throw new PluginException("Object mapping for type " + clazz.getName() + " not found.");
        }
        return map.getObject(key);
    }

    public Map<Class<?>, AbstractPluginObject> getEntities() {
        return this.entities;
    }
}

