/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.text;

import java.util.Map;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPlugin;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;

public class PluginReplacerMap
extends AbstractPlugin {
    @Override
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        Object map = context.getByName("item_map");
        if (map == null) {
            return ENext.DEEP;
        }
        Node node = context.getNode();
        Nodes replaced = this.replaceMap(node.getValue(), (Map)map);
        if (replaced.size() > 1) {
            ParentNode parent = node.getParent();
            int index = parent.indexOf(node);
            parent.removeChild(index);
            for (int i = 0; i < replaced.size(); ++i) {
                parent.insertChild(replaced.get(i), index++);
            }
        }
        return ENext.DEEP;
    }

    public Nodes replaceMap(String text, Map<String, Node> map) throws PluginException {
        Nodes nodes = new Nodes();
        int pos1 = 0;
        int pos2 = text.indexOf("#{");
        int pos3 = text.indexOf("}", pos2 + "#{".length() + 1);
        while (pos2 >= 0 & pos3 > pos2) {
            nodes.append((Node)new Text(text.substring(pos1, pos2)));
            String name = text.substring(pos2, pos3 + 1);
            Node n = map.get(name);
            if (n != null) {
                if (n instanceof ParentNode) {
                    ParentNode pn = (ParentNode)n;
                    for (int i = 0; i < pn.getChildCount(); ++i) {
                        nodes.append(pn.getChild(i).copy());
                    }
                } else {
                    nodes.append(n.copy());
                }
            } else {
                nodes.append((Node)new Text(text.substring(pos2, pos3)));
            }
            pos1 = pos3 + 1;
            pos2 = text.indexOf("#{", pos1);
            pos3 = text.indexOf("}", pos2 + "#{".length() + 1);
        }
        if (pos1 != text.length() + 1) {
            nodes.append((Node)new Text(text.substring(pos1, text.length())));
        }
        return nodes;
    }
}

