/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.var;

import java.util.LinkedList;
import java.util.List;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginNamed;
import org.specrunner.plugins.core.include.PluginImport;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.util.UtilLog;

public class PluginBean
extends AbstractPluginNamed {
    public static final String BEAN_NAME = "$BEAN";
    private Object bean;

    @Override
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        if (this.bean instanceof String) {
            String old = (String)this.bean;
            LinkedList<Exception> errors = new LinkedList<Exception>();
            this.bean = this.create(old, errors);
            List<String> packages = PluginImport.getPackages(context);
            if (this.bean == null) {
                for (String pkg : packages) {
                    this.bean = this.create(pkg + "." + old, errors);
                    if (this.bean == null) continue;
                    break;
                }
            }
            if (this.bean == null && !errors.isEmpty()) {
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), new PluginException("Class '" + old + "' not found on classpath, and does not belong to any package in list: " + packages));
            }
        }
        if (this.bean != null) {
            context.saveStrict(BEAN_NAME, this.bean);
        }
        return ENext.DEEP;
    }

    protected Object create(String type, List<Exception> errors) {
        Object result = null;
        try {
            result = Class.forName(type).newInstance();
        }
        catch (InstantiationException e) {
            if (UtilLog.LOG.isTraceEnabled()) {
                UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
            }
            errors.add(e);
        }
        catch (IllegalAccessException e) {
            if (UtilLog.LOG.isTraceEnabled()) {
                UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
            }
            errors.add(e);
        }
        catch (ClassNotFoundException e) {
            if (UtilLog.LOG.isTraceEnabled()) {
                UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
            }
            errors.add(e);
        }
        return result;
    }

    public static Object getBean(IContext context) {
        return context.getByName(BEAN_NAME);
    }
}

