/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.properties.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.specrunner.SRServices;
import org.specrunner.properties.IPropertyLoader;
import org.specrunner.properties.PropertyLoaderException;
import org.specrunner.util.UtilLog;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheFactory;
import org.specrunner.util.resources.ResourceFinder;

public class PropertyLoaderImpl
implements IPropertyLoader {
    protected static ICache<String, List<Properties>> cache = SRServices.get(ICacheFactory.class).newCache(PropertyLoaderImpl.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Properties> load(String file) throws PropertyLoaderException {
        ICache<String, List<Properties>> iCache = cache;
        synchronized (iCache) {
            List<URL> files;
            List<Properties> result = cache.get(file);
            if (result != null) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Property reuse:" + result);
                }
                return result;
            }
            try {
                files = SRServices.get(ResourceFinder.class).getAllResources(file);
            }
            catch (IOException e) {
                throw new PropertyLoaderException(e);
            }
            result = this.loadUrls(files);
            this.sort(result);
            int index = 0;
            for (Properties p : result) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Property order (" + index++ + ")=" + p);
                }
                p.remove("index");
            }
            cache.put(file, result);
            return result;
        }
    }

    protected List<Properties> loadUrls(List<URL> files) throws PropertyLoaderException {
        LinkedList<Properties> properties = new LinkedList<Properties>();
        for (URL url : files) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("Loading properties:" + url);
            }
            InputStream in = null;
            try {
                in = url.openStream();
                if (in != null) {
                    Properties p = new Properties();
                    p.load(in);
                    properties.add(p);
                    continue;
                }
                if (!UtilLog.LOG.isInfoEnabled()) continue;
                UtilLog.LOG.info("Not found:" + url);
            }
            catch (IOException e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Not found:" + url, (Throwable)e);
                }
                throw new PropertyLoaderException(e);
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException e) {
                    if (!UtilLog.LOG.isDebugEnabled()) continue;
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return properties;
    }

    protected void sort(List<Properties> props) {
        Collections.sort(props, new Comparator<Properties>(){

            @Override
            public int compare(Properties o1, Properties o2) {
                double index2;
                String key = "index";
                double index1 = o1.containsKey(key) ? Double.valueOf((String)o1.get(key)) : 0.0;
                double d = index2 = o2.containsKey(key) ? Double.valueOf((String)o2.get(key)) : 0.0;
                return index1 < index2 ? -1 : (index2 < index1 ? 1 : 0);
            }
        });
    }
}

