/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.report.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.specrunner.SRServices;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.type.Assertion;
import org.specrunner.report.IReporter;
import org.specrunner.report.core.IndexComparator;
import org.specrunner.report.core.ReportPart;
import org.specrunner.report.core.Resume;
import org.specrunner.report.core.StatusComparator;
import org.specrunner.report.core.TimeComparator;
import org.specrunner.result.IResult;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.util.output.IOutputFactory;

public abstract class AbstractReport
implements IReporter {
    private static final int SECOND = 1000;
    private static final Object LOCK = new Object();
    protected static final int PERCENTAGE = 100;
    protected Long total = 0L;
    protected int index = 1;
    protected Map<Status, Integer> status = new TreeMap<Status, Integer>();
    protected Map<ActionType, Integer> types = new TreeMap<ActionType, Integer>();
    protected List<Resume> resumes = new LinkedList<Resume>();
    public static final String FEATURE_PARTS = AbstractReport.class.getName() + ".parts";
    protected List<ReportPart> parts;
    public static final List<ReportPart> DEFAULT_PARTS = Arrays.asList(new ReportPart("EXECUTION ORDER", IndexComparator.get()), new ReportPart("PERCENTAGE ORDER", TimeComparator.get()), new ReportPart("STATUS ORDER", StatusComparator.get()));

    public List<ReportPart> getParts() {
        return this.parts;
    }

    public void setParts(List<ReportPart> parts) {
        this.parts = parts;
    }

    protected void setFeatures(SRServices services) {
        IFeatureManager fm = services.lookup(IFeatureManager.class);
        this.parts = null;
        fm.set(FEATURE_PARTS, this);
        if (this.parts == null) {
            this.parts = DEFAULT_PARTS;
        }
    }

    @Override
    public void analyse(IResultSet result, Map<String, Object> model) {
        Resume r = this.createResume(result, model);
        Status s = r.getStatus();
        Integer c = this.status.get(s);
        if (c == null) {
            c = 0;
        }
        this.status.put(s, c + 1);
        List<ActionType> listTypes = result.actionTypes();
        for (ActionType at : listTypes) {
            Integer q = this.types.get(at);
            if (q == null) {
                q = 0;
            }
            this.types.put(at, q + result.filterByType(at).size());
        }
        this.total = this.total + r.getTime();
        this.resumes.add(r);
    }

    @Override
    public String resume(SRServices services) {
        String r = this.resume(services, false);
        SRServices.get(IOutputFactory.class).currentOutput().print(r);
        return r;
    }

    protected String resume(SRServices services, boolean finalResume) {
        StringBuilder sb = new StringBuilder();
        String gap = "";
        String before = "+------";
        String after = "------+";
        if (finalResume) {
            gap = "        ";
        }
        sb.append(gap);
        sb.append(before);
        String header = null;
        header = " STATISTICS (" + services.getThreadName() + ") ";
        sb.append(header);
        sb.append(after);
        sb.append("\n");
        String format = "%16s: ";
        sb.append(gap);
        sb.append(String.format(format + "%d", "NUMBER OF TESTS", this.index - 1));
        sb.append("\n");
        sb.append(gap);
        sb.append(String.format(format + "%d ms", "TOTAL TIME", this.total));
        sb.append("\n");
        sb.append(gap);
        sb.append(String.format(format + "%02d:%02d:%02d.%03d (HH:mm:ss.SSS)", "FORMATED TIME", TimeUnit.MILLISECONDS.toHours(this.total), TimeUnit.MILLISECONDS.toMinutes(this.total), TimeUnit.MILLISECONDS.toSeconds(this.total), this.total % 1000L));
        sb.append("\n");
        sb.append(gap);
        sb.append(String.format(format + "%7.2f ms", "AVERAGE TIME", Float.valueOf(this.index > 1 ? (float)this.total.longValue() / (float)(this.index - 1) : (float)this.total.longValue())));
        sb.append("\n");
        sb.append(gap);
        sb.append(String.format(format + "[%s]", "STATUS", this.status()));
        sb.append("\n");
        sb.append(gap);
        sb.append(String.format(format + "[%s]", "TYPES", this.types()));
        sb.append("\n");
        sb.append(gap);
        sb.append(before);
        for (int i = 0; i < header.length(); ++i) {
            sb.append("-");
        }
        sb.append(after);
        sb.append("\n");
        return sb.toString();
    }

    protected String status() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Status, Integer> e : this.status.entrySet()) {
            sb.append(e.getKey().getName() + "=" + e.getValue() + ", ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    protected String types() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ActionType, Integer> e : this.types.entrySet()) {
            sb.append(e.getKey().getName() + "=" + e.getValue() + ", ");
        }
        return sb.length() > 2 ? sb.substring(0, sb.length() - 2) : sb.toString();
    }

    protected Resume createResume(IResultSet result, Map<String, Object> model) {
        Long time = (Long)model.get("time");
        Status s = result.getStatus();
        Resume r = this.createInstance(result, model);
        r.setIndex(this.index++);
        r.setTime(time);
        r.setTimestamp(model.get("date"));
        r.setInput(model.get("input"));
        r.setOutput(model.get("output"));
        r.setStatus(s);
        List byStatus = result.filterByStatus(new Status[]{s});
        r.setStatusCounter(byStatus.size());
        r.setStatusTotal(result.size());
        List<IResult> statusByType = result.filterByType(byStatus, Assertion.INSTANCE);
        r.setAssertionCounter(statusByType.size());
        List<IResult> totalByType = result.filterByType(Assertion.INSTANCE);
        r.setAssertionTotal(totalByType.size());
        return r;
    }

    protected Resume createInstance(IResultSet result, Map<String, Object> model) {
        return new Resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(SRServices services) {
        if (!this.resumes.isEmpty()) {
            this.setFeatures(services);
            Object object = LOCK;
            synchronized (object) {
                this.dumpStart(services);
                for (ReportPart rp : this.parts) {
                    this.dumpPart(services, rp.getHeader(), this.orderedList(this.resumes, rp.getComparator()));
                }
                this.dumpResume(services, this.resume(services, true));
                this.dumpEnd(services);
            }
        }
    }

    protected abstract void dumpStart(SRServices var1);

    protected List<Resume> orderedList(List<Resume> list, Comparator<Resume> comparator) {
        LinkedList<Resume> copy = new LinkedList<Resume>(list);
        Collections.sort(copy, comparator);
        return copy;
    }

    protected abstract void dumpPart(SRServices var1, String var2, List<Resume> var3);

    protected abstract void dumpResume(SRServices var1, String var2);

    protected abstract void dumpEnd(SRServices var1);

    protected double asPercentage(Long time) {
        return (double)time.longValue() / (double)this.total.longValue() * 100.0;
    }
}

