/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.report.core;

import java.util.List;
import org.specrunner.SRServices;
import org.specrunner.report.core.AbstractReport;
import org.specrunner.report.core.Resume;
import org.specrunner.util.output.IOutput;
import org.specrunner.util.output.IOutputFactory;

public class ReporterTxt
extends AbstractReport {
    @Override
    protected void dumpStart(SRServices services) {
        IOutput out = services.lookup(IOutputFactory.class).currentOutput();
        out.print("+-------------------------------- TXT REPORT -------------------------------------+\n");
        out.print("+  THREAD: " + services.getThreadName() + "\n");
        out.print("+--------------------------------\n");
    }

    @Override
    protected void dumpPart(SRServices services, String header, List<Resume> list) {
        IOutput out = services.lookup(IOutputFactory.class).currentOutput();
        out.printf("\t+---------------- TXT (%s)---------------------+%n", header);
        String pattern = "\t%10s %10s | %10s | %7s | %-24s | %-15s | %-10s | %10s%n";
        out.printf(pattern, "", "#", "TIME (ms)", "%", "ON", "STATUS", "ASSERTS", "INPUT <-> OUTPUT");
        pattern = "\t%10s %10s | %10s | %7.2f | %23s  | %-15s | %-10s | %10s%n";
        for (Resume r : list) {
            out.printf(pattern, "", r.getIndex(), r.getTime(), this.asPercentage(r.getTime()), r.getTimestamp(), r.getStatus().getName() + " " + r.getStatusCounter() + "/" + r.getStatusTotal(), r.getAssertionCounter() + "/" + r.getAssertionTotal(), r.getInput() + " <-> " + r.getOutput());
        }
        out.print("\t          ----------------------------------\n");
        pattern = "\t%10s %10s : %10d (AVG: %.2f)%n";
        out.printf(pattern, "", "TOTAL", this.total, (double)this.total.longValue() / (double)(list.isEmpty() ? 1 : list.size()));
        out.printf("\t+---------------------%s-----------------------+%n", "");
    }

    @Override
    protected void dumpResume(SRServices services, String resume) {
        IOutput out = services.lookup(IOutputFactory.class).currentOutput();
        out.print(resume);
    }

    @Override
    protected void dumpEnd(SRServices services) {
        IOutput out = services.lookup(IOutputFactory.class).currentOutput();
        out.print("+---------------------------------------------------------------------------------+\n");
    }
}

