/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.result.core;

import java.io.IOException;
import nu.xom.Node;
import nu.xom.Text;
import org.specrunner.context.IBlock;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.type.Undefined;
import org.specrunner.result.IResult;
import org.specrunner.result.IWritable;
import org.specrunner.result.Status;
import org.specrunner.util.ExceptionUtil;
import org.specrunner.util.UtilLog;

public class ResultImpl
implements IResult {
    protected Status status;
    protected IBlock source;
    protected String message;
    protected Throwable failure;
    protected IWritable writable;

    public ResultImpl(Status status, IBlock source, String message, Throwable failure, IWritable writable) {
        this.status = status;
        this.source = source;
        this.message = message;
        this.failure = failure;
        this.writable = writable;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public boolean hasBlock() {
        return this.getBlock() != null;
    }

    @Override
    public IBlock getBlock() {
        return this.source;
    }

    @Override
    public boolean hasMessage() {
        return this.getMessage() != null;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public boolean hasFailure() {
        return this.getFailure() != null;
    }

    @Override
    public Throwable getFailure() {
        return this.failure;
    }

    @Override
    public boolean hasWritable() {
        return this.getWritable() != null;
    }

    @Override
    public IWritable getWritable() {
        return this.writable;
    }

    @Override
    public ActionType getActionType() {
        IPlugin p;
        if (this.source != null && (p = this.source.getPlugin()) != null) {
            return p.getActionType();
        }
        return Undefined.INSTANCE;
    }

    @Override
    public String asString() {
        String msg2;
        String msg1;
        block4: {
            msg1 = "";
            if (!this.source.hasNode()) {
                IPlugin plugin = this.source.getPlugin();
                msg1 = ". on " + plugin + "[" + plugin.getParameters().getAllParameters() + "]";
            }
            String string = msg2 = this.hasFailure() ? this.getFailure().getMessage() : this.getMessage();
            if (this.hasFailure()) {
                try {
                    msg2 = msg2 + "\n" + ExceptionUtil.toString(this.getFailure());
                }
                catch (IOException e) {
                    if (!UtilLog.LOG.isDebugEnabled()) break block4;
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return msg1 + msg2;
    }

    @Override
    public Node asNode() {
        return new Text(this.asString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.status.getName());
        sb.append("(");
        if (this.source.hasNode()) {
            sb.append(this.source.getNode().toXML());
        } else {
            sb.append(this.source.getPlugin());
        }
        sb.append(",");
        sb.append(this.message);
        if (this.failure != null) {
            sb.append("," + this.failure.getMessage());
        }
        sb.append(")." + this.writable);
        return sb.toString();
    }
}

