/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.result.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.IActionType;
import org.specrunner.result.IResult;
import org.specrunner.result.IResultSet;
import org.specrunner.result.IWritable;
import org.specrunner.result.Status;
import org.specrunner.result.core.ResultImpl;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.source.ISource;
import org.specrunner.source.SourceException;

public class ResultSetImpl
extends LinkedList<IResult>
implements IResultSet {
    private boolean recordSuccess = true;
    private List<String> messages;
    private boolean sorted;

    @Override
    public Boolean getRecordSuccess() {
        return this.recordSuccess;
    }

    @Override
    public void setRecordSuccess(Boolean recordSuccess) {
        this.recordSuccess = recordSuccess;
    }

    @Override
    public void setMessages(String[] messages) {
        if (messages != null && messages.length > 0) {
            this.messages = new LinkedList<String>();
            for (int i = 0; i < messages.length; ++i) {
                this.messages.add(messages[i]);
            }
        }
    }

    @Override
    public String[] getMessages() {
        return this.messages == null ? null : this.messages.toArray(new String[this.messages.size()]);
    }

    @Override
    public void setSorted(Boolean sorted) {
        this.sorted = sorted;
    }

    @Override
    public Boolean getSorted() {
        return this.sorted;
    }

    @Override
    public void consolidate(IContext context) {
        if (this.messages == null) {
            return;
        }
        LinkedList<IResult> items = new LinkedList<IResult>();
        LinkedList<String> received = new LinkedList<String>();
        for (IResult r : this) {
            if (!r.getStatus().isError()) continue;
            items.add(r);
            received.add(this.getMessage(r.getMessage(), r.getFailure()));
        }
        StringBuilder errors = new StringBuilder();
        LinkedList<String> expected = new LinkedList<String>(this.messages);
        if (this.sorted) {
            int max = Math.min(received.size(), expected.size());
            for (int i = 0; i < max; ++i) {
                if (!((String)expected.get(i)).equals(received.get(i))) {
                    errors.append("Expected '" + (String)expected.get(i) + "' does not match received '" + (String)received.get(i) + "'.\n");
                    continue;
                }
                ((IResult)items.get(i)).setStatus(Success.INSTANCE);
            }
            if (max < expected.size()) {
                errors.append("Expected messages missing:\n");
                this.append(errors, expected.subList(max, expected.size()));
                errors.append('\n');
            }
            if (max < received.size()) {
                errors.append("Unexpected messages received:\n");
                this.append(errors, received.subList(max, received.size()));
                errors.append('\n');
            }
        } else {
            LinkedList<String> extraReceived = new LinkedList<String>(received);
            LinkedList<String> extraExpected = new LinkedList<String>(expected);
            extraReceived.removeAll(expected);
            extraExpected.removeAll(received);
            if (extraExpected.size() > 0) {
                errors.append("Expected messages missing:\n");
                this.append(errors, extraExpected);
                errors.append('\n');
            }
            if (extraReceived.size() > 0) {
                errors.append("Unexpected messages received:\n");
                this.append(errors, extraReceived);
                errors.append('\n');
            }
        }
        if (errors.length() == 0) {
            for (IResult r : items) {
                if (!r.getStatus().isError()) continue;
                r.setStatus(Success.INSTANCE);
            }
        } else {
            try {
                ISource source = context.getSources().getLast();
                Document document = source.getDocument();
                Element root = document.getRootElement();
                this.addResult((Status)Failure.INSTANCE, context.newBlock((Node)root, null), new Exception(errors.toString()));
            }
            catch (SourceException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void append(StringBuilder errors, List<String> list) {
        for (String s : list) {
            errors.append('\t');
            errors.append(s);
        }
    }

    protected String getMessage(String message, Throwable failure) {
        return message != null ? message : (failure != null ? failure.getMessage() : null);
    }

    @Override
    public Status getStatus() {
        Status result = Success.INSTANCE;
        for (IResult s : this) {
            result = result.max(s.getStatus());
        }
        return result;
    }

    @Override
    public <T extends Status> Iterable<T> availableStatus() {
        LinkedList<Status> result = new LinkedList<Status>();
        for (IResult s : this) {
            if (result.contains(s.getStatus())) continue;
            result.add(s.getStatus());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public <T extends Status> List<T> errorStatus() {
        LinkedList<Status> result = new LinkedList<Status>();
        for (IResult s : this) {
            Status r = s.getStatus();
            if (!r.isError() || result.contains(r)) continue;
            result.add(r);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public <T extends Status> List<IResult> filterByStatus(T ... status) {
        return this.filterByStatus(0, this.size(), (Status[])status);
    }

    @Override
    public <T extends Status> List<IResult> filterByStatus(int start, int end, T ... status) {
        int i;
        LinkedList<IResult> result = new LinkedList<IResult>();
        HashSet<T> valid = new HashSet<T>();
        for (i = 0; i < status.length; ++i) {
            valid.add(status[i]);
        }
        for (i = start; i < end; ++i) {
            IResult t = (IResult)this.get(i);
            if (!valid.contains(t.getStatus())) continue;
            result.add(t);
        }
        return result;
    }

    @Override
    public <T extends Status> int countStatus(T ... status) {
        return this.countStatus(0, this.size(), (Status[])status);
    }

    @Override
    public <T extends Status> int countStatus(int start, int end, T ... status) {
        return this.filterByStatus(start, end, (Status[])status).size();
    }

    @Override
    public List<ActionType> actionTypes() {
        return this.actionTypes(this);
    }

    @Override
    public List<ActionType> actionTypes(List<IResult> subset) {
        TreeSet<ActionType> set = new TreeSet<ActionType>();
        for (IResult s : subset) {
            ActionType at = s.getActionType();
            if (set.contains(at)) continue;
            set.add(at);
        }
        return new LinkedList<ActionType>(set);
    }

    @Override
    public List<IResult> filterByType(ActionType ... actionType) {
        return this.filterByType(this, actionType);
    }

    @Override
    public List<IResult> filterByType(List<IResult> subset, ActionType ... actionType) {
        LinkedList<IResult> result = new LinkedList<IResult>();
        HashSet<ActionType> valid = new HashSet<ActionType>();
        for (int i = 0; i < actionType.length; ++i) {
            valid.add(actionType[i]);
        }
        for (IResult r : subset) {
            if (!valid.contains(r.getActionType())) continue;
            result.add(r);
        }
        return result;
    }

    @Override
    public int countType(ActionType ... status) {
        return this.countType(this, status);
    }

    @Override
    public int countType(List<IResult> result, ActionType ... status) {
        return this.filterByType(result, status).size();
    }

    @Override
    public IResult addResult(Status status, IBlock source) {
        return this.addResult(status, source, null, null, null);
    }

    @Override
    public IResult addResult(Status status, IBlock source, IWritable writable) {
        return this.addResult(status, source, null, null, writable);
    }

    @Override
    public IResult addResult(Status status, IBlock source, String message) {
        return this.addResult(status, source, message, null, null);
    }

    @Override
    public IResult addResult(Status status, IBlock source, String message, IWritable writable) {
        return this.addResult(status, source, message, null, writable);
    }

    @Override
    public IResult addResult(Status status, IBlock source, Throwable failure) {
        return this.addResult(status, source, null, failure, null);
    }

    @Override
    public IResult addResult(Status status, IBlock source, Throwable failure, IWritable writable) {
        return this.addResult(status, source, null, failure, writable);
    }

    protected IResult addResult(Status status, IBlock source, String message, Throwable failure, IWritable writable) {
        status = this.analyzeStatus(status, message, failure);
        if (!this.recordSuccess && !status.isError()) {
            return null;
        }
        ResultImpl result = new ResultImpl(status, source, message, failure, writable);
        if (this.add(result)) {
            return result;
        }
        return null;
    }

    protected Status analyzeStatus(Status status, String message, Throwable failure) {
        if (this.messages != null && status.isError()) {
            if (!this.sorted) {
                String tmp = this.getMessage(message, failure);
                if (this.messages.contains(tmp)) {
                    this.messages.remove(tmp);
                    status = Success.INSTANCE;
                }
            } else if (!this.messages.isEmpty() && this.messages.get(0).equals(message)) {
                this.messages.remove(0);
                status = Success.INSTANCE;
            }
        }
        return status;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName(this.getStatus()) + "(total:" + this.size() + this.details(this) + ")\n");
        for (Status s : this.availableStatus()) {
            List filter = this.filterByStatus(new Status[]{s});
            sb.append("  " + this.getName(s) + "(" + this.countStatus(new Status[]{s}) + this.details(filter) + ")\n");
            if (!s.isError()) continue;
            for (IResult i : filter) {
                sb.append("    " + i + "\n");
            }
        }
        return sb.toString();
    }

    protected String getName(Status s) {
        return s.getName().toUpperCase();
    }

    protected StringBuilder details(List<IResult> list) {
        StringBuilder sb = new StringBuilder(":[");
        int i = 0;
        for (ActionType t : this.actionTypes()) {
            if (i++ > 0) {
                sb.append('|');
            }
            int size = this.filterByType(list, t).size();
            sb.append(t.getName() + "=" + size);
        }
        sb.append("]");
        return sb;
    }

    protected String getName(Class<IActionType> t) {
        return t.getSimpleName().substring(1).toLowerCase();
    }

    @Override
    public String asString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName(this.getStatus()) + "(total:" + this.size() + this.details(this) + ")->");
        int i = 0;
        for (Status s : this.availableStatus()) {
            if (i++ > 0) {
                sb.append(',');
            }
            sb.append(this.getName(s) + "(" + this.countStatus(new Status[]{s}) + this.details(this.filterByStatus(new Status[]{s})) + ")");
        }
        List errors = this.errorStatus();
        if (!errors.isEmpty()) {
            sb.append("\n");
            for (Status status : errors) {
                int index = 0;
                List filter = this.filterByStatus(new Status[]{status});
                sb.append("\t" + this.getName(status) + " (" + filter.size() + this.details(filter) + "):\n");
                for (IResult r : filter) {
                    sb.append("\t\t[" + ++index);
                    String msg = r.asString();
                    if (msg != null) {
                        msg = msg.replace("\n", "\n\t\t\t");
                    }
                    sb.append("]=" + msg + "\n");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public Node asNode() {
        Element td;
        Element table = new Element("table");
        table.addAttribute(new Attribute("class", "sr_resultset"));
        Element tr = new Element("tr");
        table.appendChild((Node)tr);
        for (Status s : this.availableStatus()) {
            td = new Element("th");
            tr.appendChild((Node)td);
            td.addAttribute(new Attribute("class", s.getCssName()));
            td.appendChild(s.asNode());
            td.appendChild("(" + this.countStatus(new Status[]{s}) + ")");
        }
        tr = new Element("tr");
        table.appendChild((Node)tr);
        for (Status s : this.availableStatus()) {
            td = new Element("td");
            tr.appendChild((Node)td);
            Element sub = new Element("table");
            sub.addAttribute(new Attribute("class", "sr_actiontypes"));
            td.appendChild((Node)sub);
            List filter = this.filterByStatus(new Status[]{s});
            List<ActionType> acs = this.actionTypes(this);
            for (ActionType at : acs) {
                Element subtr = new Element("tr");
                sub.appendChild((Node)subtr);
                Element subtd = new Element("td");
                subtr.appendChild((Node)subtd);
                subtd.appendChild(at.asNode());
                td.addAttribute(new Attribute("class", at.getCssName()));
                subtd = new Element("td");
                subtr.appendChild((Node)subtd);
                subtd.addAttribute(new Attribute("style", "text-align:right;"));
                subtd.appendChild("" + this.countType(filter, at));
            }
        }
        return table;
    }
}

