/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.reuse.core;

import java.util.HashMap;
import org.specrunner.reuse.IReusable;
import org.specrunner.reuse.IReuseManager;
import org.specrunner.util.UtilLog;

public class ReusableManagerImpl
extends HashMap<String, IReusable<?>>
implements IReuseManager {
    @Override
    public IReusable<?> put(String name, IReusable<?> resource) {
        IReusable ir = (IReusable)this.get(name);
        if (ir != null && ir.getObject() != resource.getObject()) {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Release old reference:" + ir.getName() + " -> " + ir.getObject());
            }
            ir.release();
        }
        return super.put(name, resource);
    }

    @Override
    public void remove(String name) {
        IReusable ir = (IReusable)this.get(name);
        if (ir != null) {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Release:" + ir.getName() + " -> " + ir.getObject());
            }
            ir.release();
            this.remove(ir);
        }
    }
}

