/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.runner.core;

import java.util.LinkedList;
import java.util.List;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.IPluginFactory;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.PluginNop;
import org.specrunner.runner.IFilter;
import org.specrunner.util.UtilLog;

public class FilterDefault
implements IFilter {
    public static final String FEATURE_DISABLED_ALIASES = FilterDefault.class.getName() + ".disabledAliases";
    public static final String FEATURE_ENABLED_ALIASES = FilterDefault.class.getName() + ".enabledAliases";
    public static final String FEATURE_DISABLED_TYPES = FilterDefault.class.getName() + ".disabledTypes";
    public static final String FEATURE_ENABLED_TYPES = FilterDefault.class.getName() + ".enabledTypes";
    public static final ThreadLocal<FilterDefault> INSTANCE = new ThreadLocal<FilterDefault>(){

        @Override
        protected FilterDefault initialValue() {
            return new FilterDefault();
        }
    };
    protected List<String> disabledAliases;
    protected List<String> enabledAliases;
    protected List<? extends ActionType> disabledTypes;
    protected List<? extends ActionType> enabledTypes;
    protected boolean showMessage = true;

    public void setDisabledAliases(List<String> disabledAliases) {
        if (disabledAliases == null) {
            this.disabledAliases = null;
        } else {
            this.disabledAliases = new LinkedList<String>();
            for (String s : disabledAliases) {
                if (s == null) continue;
                this.disabledAliases.add(s.toLowerCase());
            }
        }
    }

    public List<String> getDisabledAliases() {
        return this.disabledAliases;
    }

    public void setEnabledAliases(List<String> enabledAliases) {
        if (enabledAliases == null) {
            this.enabledAliases = null;
        } else {
            this.enabledAliases = new LinkedList<String>();
            for (String s : enabledAliases) {
                if (s == null) continue;
                this.enabledAliases.add(s.toLowerCase());
            }
        }
    }

    public List<String> getEnabledAliases() {
        return this.enabledAliases;
    }

    public void setDisabledTypes(List<? extends ActionType> disabledTypes) {
        this.disabledTypes = disabledTypes == null ? null : new LinkedList<ActionType>(disabledTypes);
    }

    public List<? extends ActionType> getDisabledTypes() {
        return this.disabledTypes;
    }

    public void setEnabledTypes(List<? extends ActionType> enabledTypes) {
        this.enabledTypes = enabledTypes == null ? null : new LinkedList<ActionType>(enabledTypes);
    }

    public List<? extends ActionType> getEnabledTypes() {
        return this.enabledTypes;
    }

    public boolean isShowMessage() {
        return this.showMessage;
    }

    public void setShowMessage(boolean showMessage) {
        this.showMessage = showMessage;
    }

    @Override
    public void initialize(IContext context) {
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_DISABLED_ALIASES, this);
        fm.set(FEATURE_ENABLED_ALIASES, this);
        fm.set(FEATURE_DISABLED_TYPES, this);
        fm.set(FEATURE_ENABLED_TYPES, this);
    }

    @Override
    public boolean accept(IBlock block) {
        IPluginFactory factory = SRServices.get(IPluginFactory.class);
        IPlugin plugin = block.getPlugin();
        if (plugin != PluginNop.emptyPlugin()) {
            try {
                boolean actionEnabled;
                boolean hasEnabled;
                String alias = factory.getAlias(plugin.getClass());
                boolean hasDisabled = this.disabledAliases != null && this.disabledAliases.contains(alias);
                boolean bl = hasEnabled = this.enabledAliases != null && !this.enabledAliases.contains(alias);
                if (alias != null && hasDisabled || hasEnabled) {
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("Plugin '" + alias + "' ignored.");
                    }
                    return false;
                }
                ActionType type = plugin.getActionType();
                boolean actionDisabled = this.disabledTypes != null && this.disabledTypes.contains(type);
                boolean bl2 = actionEnabled = this.enabledTypes != null && !this.enabledTypes.contains(type);
                if (type != null && actionDisabled || actionEnabled) {
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("Plugin '" + type.asString() + "' ignored.");
                    }
                    return false;
                }
            }
            catch (PluginException e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Plugin '" + plugin.getClass() + "' has no alias.");
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean showMessage(IBlock block) {
        return this.showMessage;
    }
}

