/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.runner.core;

import java.util.List;
import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.SRServices;
import org.specrunner.SpecRunnerException;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.context.IModel;
import org.specrunner.listeners.IListenerManager;
import org.specrunner.listeners.INodeListener;
import org.specrunner.listeners.IPluginListener;
import org.specrunner.listeners.ISourceListener;
import org.specrunner.parameters.IParameterHolder;
import org.specrunner.parameters.core.UtilParametrized;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.IPluginFactory;
import org.specrunner.plugins.IPluginGroup;
import org.specrunner.plugins.ISleepPlugin;
import org.specrunner.plugins.ITestPlugin;
import org.specrunner.plugins.ITimedPlugin;
import org.specrunner.plugins.IWaitPlugin;
import org.specrunner.plugins.PluginException;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Ignored;
import org.specrunner.result.status.Info;
import org.specrunner.runner.IFilter;
import org.specrunner.runner.IRunner;
import org.specrunner.runner.RunnerException;
import org.specrunner.runner.core.FilterDefault;
import org.specrunner.source.ISource;
import org.specrunner.source.SourceException;
import org.specrunner.util.UtilLog;
import org.specrunner.util.xom.UtilNode;

public class RunnerImpl
implements IRunner {
    private IFilter filter;

    @Override
    public IFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    @Override
    public void run(ISource source, IContext context, IResultSet result) throws RunnerException {
        List<ISourceListener> listeners = SRServices.get(IListenerManager.class).filterByType(ISourceListener.class);
        for (ISourceListener sl : listeners) {
            sl.onBefore(source, context, result);
        }
        try {
            this.local((Node)source.getDocument(), context, result, null);
        }
        catch (SourceException e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new RunnerException(e);
        }
        finally {
            for (ISourceListener sl : listeners) {
                sl.onAfter(source, context, result);
            }
        }
    }

    @Override
    public void run(Node node, IContext context, IResultSet result) throws RunnerException {
        this.local(node, context, result, null);
    }

    @Override
    public void run(IPlugin plugin, IContext context, IResultSet result) throws RunnerException {
        if (plugin instanceof IPluginGroup) {
            IPluginGroup group = (IPluginGroup)plugin;
            for (IPlugin p : group.getChildren()) {
                this.run(p, context, result);
            }
        } else {
            this.local(null, context, result, plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void local(Node node, IContext context, IResultSet result, IPlugin previous) throws RunnerException {
        List<INodeListener> nodeListeners = SRServices.get(IListenerManager.class).filterByType(INodeListener.class);
        ENext doNode = this.nodeStart(node, context, result, nodeListeners);
        if (doNode == ENext.SKIP) {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Node listener returned '" + (Object)((Object)doNode) + "'.");
            }
            return;
        }
        IBlock block = context.newBlock(node, null);
        try {
            context.push(block);
            IPluginFactory factory = SRServices.get(IPluginFactory.class);
            IPlugin plugin = previous == null ? factory.newPlugin(node, context) : previous;
            block.setPlugin(plugin);
            if (!block.isValid()) {
                return;
            }
            IFilter local = this.filter;
            if (local == null) {
                local = FilterDefault.INSTANCE.get();
            }
            if (local != null) {
                local.initialize(context);
                if (!local.accept(block)) {
                    if (local.showMessage(block)) {
                        result.addResult((Status)Ignored.INSTANCE, block, "This block has been disabled.");
                    }
                    return;
                }
            }
            context.addMetadata();
            List<IPluginListener> listeners = SRServices.get(IListenerManager.class).filterByType(IPluginListener.class);
            this.initialization(context, result, plugin, listeners);
            if (this.checkConditional(plugin, context)) {
                this.doWait(plugin, context);
                ENext next = this.start(context, result, plugin, listeners);
                if (node != null && next == ENext.DEEP && block.hasChildren()) {
                    Node deep = block.isChanged() ? block.getNode() : node;
                    for (int i = 0; i < deep.getChildCount(); ++i) {
                        Node child = deep.getChild(i);
                        if (child instanceof Element) {
                            if (UtilNode.isIgnore(child)) continue;
                            this.local(child, context, result, null);
                            continue;
                        }
                        this.local(child, context, result, null);
                    }
                }
                factory.finalizePlugin(node, context, plugin);
                this.end(context, result, plugin, listeners);
            } else if (block.hasNode()) {
                result.addResult((Status)Info.INSTANCE, block, "Conditional '" + ((Element)node).getAttributeValue("condition") + "' prevented execution.");
            } else {
                result.addResult((Status)Info.INSTANCE, block, "Conditional prevented execution. " + plugin);
            }
            this.doSleep(plugin, context);
        }
        catch (Exception e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            result.addResult((Status)Failure.INSTANCE, block, e);
        }
        finally {
            context.pop();
            for (INodeListener nl : nodeListeners) {
                nl.onAfter(node, context, result);
            }
        }
    }

    protected ENext nodeStart(Node node, IContext context, IResultSet result, List<INodeListener> listeners) {
        ENext doNode = listeners.isEmpty() ? ENext.DEEP : ENext.SKIP;
        for (INodeListener nl : listeners) {
            doNode = doNode.max(nl.onBefore(node, context, result));
        }
        return doNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialization(IContext context, IResultSet result, IPlugin plugin, List<IPluginListener> listeners) throws PluginException {
        Node node = context.getNode();
        if (node instanceof Element) {
            UtilParametrized.setProperties(context, (IParameterHolder)plugin, (Element)node);
        }
        for (IPluginListener sl : listeners) {
            sl.onBeforeInit(plugin, context, result);
        }
        try {
            plugin.initialize(context);
        }
        finally {
            for (IPluginListener sl : listeners) {
                sl.onAfterInit(plugin, context, result);
            }
        }
    }

    protected boolean checkConditional(IPlugin plugin, IContext context) throws SpecRunnerException {
        Boolean out = null;
        if (plugin instanceof ITestPlugin) {
            ITestPlugin testPlugin = (ITestPlugin)plugin;
            IModel<Boolean> model = testPlugin.getConditionModel();
            out = model != null ? model.getObject(context) : testPlugin.getCondition();
        }
        return out == null || out != false;
    }

    protected void doWait(IPlugin plugin, IContext context) throws SpecRunnerException {
        block5: {
            if (plugin instanceof IWaitPlugin) {
                IWaitPlugin waitPlugin = (IWaitPlugin)plugin;
                IModel<Long> model = waitPlugin.getWaitModel();
                Long sleep = null;
                sleep = model != null ? model.getObject(context) : waitPlugin.getWait();
                if (sleep != null) {
                    try {
                        if (UtilLog.LOG.isInfoEnabled()) {
                            UtilLog.LOG.info("Wait for " + sleep + "mls.");
                        }
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException e) {
                        if (!UtilLog.LOG.isDebugEnabled()) break block5;
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ENext start(IContext context, IResultSet result, IPlugin plugin, List<IPluginListener> listeners) throws SpecRunnerException {
        for (IPluginListener sl : listeners) {
            sl.onBeforeStart(plugin, context, result);
        }
        ENext next = null;
        try {
            long time = System.currentTimeMillis();
            next = plugin.doStart(context, result);
            this.checkTimeout(context, result, plugin, time, "doStart()");
        }
        finally {
            for (IPluginListener sl : listeners) {
                sl.onAfterStart(plugin, context, result);
            }
        }
        return next;
    }

    protected void checkTimeout(IContext context, IResultSet result, IPlugin plugin, long start, String method) throws SpecRunnerException {
        long total = System.currentTimeMillis() - start;
        if (plugin instanceof ITimedPlugin) {
            ITimedPlugin timedPlugin = (ITimedPlugin)plugin;
            IModel<Long> model = timedPlugin.getTimeoutModel();
            Long timeout = null;
            timeout = model != null ? model.getObject(context) : timedPlugin.getTimeout();
            if (timeout != null && total > timeout) {
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), new PluginException(method + " has run out of time. time(" + total + ") > timeout(" + timeout + ")"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void end(IContext context, IResultSet result, IPlugin plugin, List<IPluginListener> listeners) throws SpecRunnerException {
        for (IPluginListener sl : listeners) {
            sl.onBeforeEnd(plugin, context, result);
        }
        try {
            long time = System.currentTimeMillis();
            plugin.doEnd(context, result);
            this.checkTimeout(context, result, plugin, time, "doEnd()");
        }
        finally {
            for (IPluginListener sl : listeners) {
                sl.onAfterEnd(plugin, context, result);
            }
        }
    }

    protected void doSleep(IPlugin plugin, IContext context) throws SpecRunnerException {
        block5: {
            if (plugin instanceof ISleepPlugin) {
                ISleepPlugin sleepPlugin = (ISleepPlugin)plugin;
                IModel<Long> model = sleepPlugin.getSleepModel();
                Long sleep = null;
                sleep = model != null ? model.getObject(context) : sleepPlugin.getSleep();
                if (sleep != null) {
                    try {
                        if (UtilLog.LOG.isInfoEnabled()) {
                            UtilLog.LOG.info("Sleep for " + sleep + "mls.");
                        }
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException e) {
                        if (!UtilLog.LOG.isDebugEnabled()) break block5;
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

