/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.source.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.XPathContext;
import org.specrunner.SRServices;
import org.specrunner.source.IDocumentLoader;
import org.specrunner.source.ISource;
import org.specrunner.source.ISourceFactory;
import org.specrunner.source.SourceException;
import org.specrunner.source.core.EncodedImpl;
import org.specrunner.source.core.SourceImpl;
import org.specrunner.source.namespace.INamespaceInfo;
import org.specrunner.source.namespace.INamespaceLoader;
import org.specrunner.source.namespace.core.NamespaceInfoDefault;
import org.specrunner.util.UtilLog;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheFactory;

public abstract class AbstractSourceFactory
extends EncodedImpl
implements ISourceFactory {
    protected static ICache<String, Document> cache = SRServices.get(ICacheFactory.class).newCache(AbstractSourceFactory.class.getName() + ".document");
    protected static ICache<String, INamespaceInfo> namespace = SRServices.get(ICacheFactory.class).newCache(AbstractSourceFactory.class.getName() + ".namespace");

    @Override
    public void initialize() {
    }

    @Override
    public ISource newSource(Object source) throws SourceException {
        URI uriTmp;
        String strTmp;
        block2: {
            strTmp = String.valueOf(source);
            uriTmp = null;
            try {
                uriTmp = new URI(strTmp);
                strTmp = uriTmp.toString();
            }
            catch (URISyntaxException e) {
                if (!UtilLog.LOG.isTraceEnabled()) break block2;
                UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
            }
        }
        final URI uri = uriTmp;
        final String target = strTmp;
        IDocumentLoader loader = new IDocumentLoader(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Document load() throws SourceException {
                long time = System.currentTimeMillis();
                Document result = null;
                ICache<String, Document> iCache = cache;
                synchronized (iCache) {
                    result = cache.get(target);
                    if (result == null) {
                        result = AbstractSourceFactory.this.fromTarget(uri, AbstractSourceFactory.this.cleanTarget(target), AbstractSourceFactory.this.getEncoding());
                        AbstractSourceFactory.this.addDoctype(result);
                        cache.put(target, result);
                    }
                }
                result = (Document)result.copy();
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Load time " + (System.currentTimeMillis() - time) + " ms for: " + target);
                }
                return result;
            }
        };
        INamespaceLoader nsloader = new INamespaceLoader(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INamespaceInfo load(Document doc) {
                long time = System.currentTimeMillis();
                INamespaceInfo result = null;
                ICache<String, INamespaceInfo> iCache = namespace;
                synchronized (iCache) {
                    result = namespace.get(target);
                    if (result == null) {
                        result = this.loadDoc(doc);
                        namespace.put(target, result);
                    }
                }
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Namespace load time " + (System.currentTimeMillis() - time) + " ms for: " + target);
                }
                return result;
            }

            protected INamespaceInfo loadDoc(Document doc) {
                HashMap<String, String> prefixToUri = new HashMap<String, String>();
                HashMap<String, String> uriToPrefix = new HashMap<String, String>();
                HashMap<String, XPathContext> uriToContext = new HashMap<String, XPathContext>();
                HashMap<String, XPathContext> prefixToContext = new HashMap<String, XPathContext>();
                Element root = doc.getRootElement();
                for (int i = 0; i < root.getNamespaceDeclarationCount(); ++i) {
                    String prefix = root.getNamespacePrefix(i);
                    if (prefix.isEmpty()) continue;
                    String uri = root.getNamespaceURI(prefix);
                    prefixToUri.put(prefix, uri);
                    uriToPrefix.put(uri, prefix);
                    XPathContext context = new XPathContext(prefix, uri);
                    uriToContext.put(uri, context);
                    prefixToContext.put(prefix, context);
                }
                return new NamespaceInfoDefault(prefixToUri, uriToPrefix, prefixToContext, uriToContext);
            }
        };
        return new SourceImpl(this.getEncoding(), strTmp, this, loader, nsloader);
    }

    protected abstract Document fromTarget(URI var1, String var2, String var3) throws SourceException;

    protected String cleanTarget(String target) {
        return target == null ? target : target.replace("file:///", "").replace("file://", "").replace("file:/", "");
    }

    protected Document addDoctype(Document document) {
        if (document.getDocType() == null) {
            DocType dt = new DocType("html", "-//W3C//DTD XHTML 1.0 Transitional//EN", "");
            document.insertChild((Node)dt, 0);
        }
        return document;
    }
}

