/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.source.core;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import nu.xom.Builder;
import nu.xom.Document;
import org.specrunner.SRServices;
import org.specrunner.source.IBuilderFactory;
import org.specrunner.source.SourceException;
import org.specrunner.source.core.AbstractSourceFactory;
import org.specrunner.util.UtilLog;

public class SourceFactoryHtml
extends AbstractSourceFactory {
    @Override
    protected Document fromTarget(URI uri, String target, String encoding) throws SourceException {
        Document document = null;
        InputStream fin = null;
        InputStream bin = null;
        try {
            fin = uri == null || !target.startsWith("http") ? new FileInputStream(target) : uri.toURL().openStream();
            bin = new BufferedInputStream(fin);
            document = this.load(new InputStreamReader(bin, encoding));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new SourceException("Could not load the source '" + target + "'.", e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new SourceException("Unsupported charset '" + encoding + "'.", e);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new SourceException("Invalid URI '" + uri + "'.", e);
        }
        catch (IOException e) {
            e.printStackTrace();
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new SourceException("Reading exception.", e);
        }
        catch (SourceException e) {
            e.printStackTrace();
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new SourceException("Could not load the source '" + target + "'.", e);
        }
        finally {
            block28: {
                block27: {
                    if (bin != null) {
                        try {
                            bin.close();
                            if (UtilLog.LOG.isTraceEnabled()) {
                                UtilLog.LOG.trace("Close file buffered inputstream:" + target);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            if (!UtilLog.LOG.isTraceEnabled()) break block27;
                            UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (fin != null) {
                    try {
                        fin.close();
                        if (UtilLog.LOG.isTraceEnabled()) {
                            UtilLog.LOG.trace("Close file inputstream:" + target);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (!UtilLog.LOG.isTraceEnabled()) break block28;
                        UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document load(Reader reader) throws SourceException {
        IBuilderFactory factory = SRServices.get(IBuilderFactory.class);
        Builder builder = factory.newBuilder(new HashMap<String, Object>());
        try {
            Builder builder2 = builder;
            synchronized (builder2) {
                Document build = builder.build(reader);
                return this.addDoctype(build);
            }
        }
        catch (Exception e) {
            block9: {
                e.printStackTrace();
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e1) {
                        if (!UtilLog.LOG.isDebugEnabled()) break block9;
                        UtilLog.LOG.debug(e1.getMessage(), (Throwable)e1);
                    }
                }
            }
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new SourceException("Could not load the '" + (reader != null ? reader.getClass() : null) + "' source '" + reader + "'.", e);
        }
    }
}

