/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.source.core;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Nodes;
import org.specrunner.SRServices;
import org.specrunner.source.IDocumentLoader;
import org.specrunner.source.ISource;
import org.specrunner.source.ISourceFactory;
import org.specrunner.source.SourceException;
import org.specrunner.source.namespace.INamespaceInfo;
import org.specrunner.source.namespace.INamespaceLoader;
import org.specrunner.source.resource.IResourceManager;
import org.specrunner.source.resource.IResourceManagerFactory;
import org.specrunner.util.UtilLog;

public class SourceImpl
implements ISource {
    private String encoding;
    protected String string;
    protected File file;
    protected URI uri;
    protected ISourceFactory factory;
    protected IResourceManager manager;
    protected IDocumentLoader loader;
    protected Document document;
    protected INamespaceLoader nsloader;
    protected INamespaceInfo namespaceInfo;

    public SourceImpl(String encoding, String string, ISourceFactory factory, IDocumentLoader loader, INamespaceLoader nsloader) {
        block6: {
            this.encoding = encoding;
            this.string = string;
            if (this.string != null) {
                this.file = new File(this.string);
                if (this.file.exists()) {
                    this.string = this.file.toURI().toString();
                } else {
                    this.file = null;
                }
                try {
                    this.uri = new URI(this.string);
                    if (!this.string.startsWith("http") && this.file == null) {
                        this.file = new File(this.string.replace(":", ""));
                    }
                }
                catch (URISyntaxException e) {
                    this.uri = this.file.toURI();
                    if (!UtilLog.LOG.isTraceEnabled()) break block6;
                    UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.factory = factory;
        this.loader = loader;
        this.nsloader = nsloader;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getString() {
        return this.string;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public ISourceFactory getFactory() {
        return this.factory;
    }

    @Override
    public ISource resolve(ISource other) throws SourceException {
        URI uriBase = this.getURI();
        if (uriBase == null) {
            return null;
        }
        URI uriTmp = uriBase.resolve(other.getString());
        return this.factory.newSource(uriTmp.toString());
    }

    @Override
    public String relative(ISource other) {
        int i;
        String a = this.getURI().toString();
        String b = other.getURI().toString();
        for (i = 0; i < a.length() && i < b.length() && a.charAt(i) == b.charAt(i); ++i) {
        }
        return a.substring(i);
    }

    @Override
    public IResourceManager getManager() {
        if (this.manager == null) {
            this.manager = SRServices.get(IResourceManagerFactory.class).newManager(this);
        }
        return this.manager;
    }

    @Override
    public Document getDocument() throws SourceException {
        if (this.document == null) {
            this.document = this.loader.load();
        }
        return this.document;
    }

    @Override
    public INamespaceInfo getNamespaceInfo() throws SourceException {
        if (this.namespaceInfo == null) {
            this.namespaceInfo = this.nsloader.load(this.getDocument());
        }
        return this.namespaceInfo;
    }

    @Override
    public List<Element> getScenarios() throws SourceException {
        Document d = this.getDocument();
        Nodes ns = d.query("//*[contains(@class,'scenario')] | //scenario");
        return ns.size() > 0 ? this.toElements(ns) : Arrays.asList(d.getRootElement());
    }

    protected List<Element> toElements(Nodes ns) {
        LinkedList<Element> result = new LinkedList<Element>();
        for (int i = 0; i < ns.size(); ++i) {
            result.add((Element)ns.get(i));
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.string == null ? 0 : this.string.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ISource other = (ISource)obj;
        return !(this.getURI() == null ? other.getURI() != null : !this.getURI().equals(other.getURI()));
    }

    public String toString() {
        return this.getString() + "," + this.getURI();
    }
}

