/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.source.namespace.core;

import nu.xom.Document;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.XPathContext;
import org.specrunner.source.namespace.INamespaceInfo;
import org.specrunner.source.namespace.INamespaceProcessor;

public abstract class AbstractNamespaceProcessor
implements INamespaceProcessor {
    private String prefix;
    private String uri;
    private String tag;
    private XPathContext context;

    protected AbstractNamespaceProcessor(String prefix, String uri, String tag) {
        this.prefix = prefix;
        this.uri = uri;
        this.tag = tag;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public XPathContext getContext() {
        return this.context;
    }

    public void setContext(XPathContext context) {
        this.context = context;
    }

    @Override
    public void process(INamespaceInfo info, Document document) {
        if (this.prefix != null && this.uri == null) {
            this.uri = info.getURI(this.prefix);
        }
        if (this.prefix == null && this.uri != null) {
            this.prefix = info.getPrefix(this.uri);
        }
        this.context = info.getByURI(this.prefix);
        if (this.context == null) {
            this.context = info.getByURI(this.uri);
        }
        if (this.context == null) {
            return;
        }
        this.process(info, document, this.prefix == null ? info.getPrefix(this.uri) : this.prefix);
    }

    protected void process(INamespaceInfo info, Document document, String prefix) {
        this.process(info, document, this.lookup((Node)document, prefix, this.tag));
    }

    protected Nodes lookup(Node node, String prefix, String tag) {
        return node.query("descendant::*[@" + prefix + ":" + tag + "]", this.context);
    }

    protected abstract void process(INamespaceInfo var1, Document var2, Nodes var3);
}

