/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.source.resource.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.specrunner.SRServices;
import org.specrunner.source.ISource;
import org.specrunner.source.resource.EType;
import org.specrunner.source.resource.IResource;
import org.specrunner.source.resource.ResourceException;
import org.specrunner.util.UtilLog;
import org.specrunner.util.resources.ResourceFinder;

public abstract class AbstractResource
implements IResource {
    private ISource parent;
    private String resourcePath;
    private boolean classpath;
    private EType type;

    protected AbstractResource(ISource parent, String resourcePath, boolean classpath, EType type) {
        this.parent = parent;
        this.resourcePath = resourcePath;
        this.classpath = classpath;
        this.type = type;
    }

    @Override
    public ISource getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ISource parent) {
        this.parent = parent;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public EType getType() {
        return this.type;
    }

    @Override
    public void setType(EType type) {
        this.type = type;
    }

    @Override
    public boolean isClasspath() {
        return this.classpath;
    }

    @Override
    public void setClasspath(boolean classpath) {
        this.classpath = classpath;
    }

    protected List<URL> getResourceURLs() throws ResourceException {
        List<URL> files;
        try {
            if (this.isClasspath()) {
                files = SRServices.get(ResourceFinder.class).getAllResources(this.getResourcePath());
                Collections.reverse(files);
            } else {
                files = Arrays.asList(new URL(this.getResourcePath()));
            }
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        if (files == null || files.isEmpty()) {
            throw new ResourceException("Resource " + this + " not found.");
        }
        return this.filterExisting(files);
    }

    protected List<URL> filterExisting(List<URL> urls) {
        LinkedList<URL> existing = new LinkedList<URL>();
        for (URL url : urls) {
            if ("file".equals(url.getProtocol())) {
                String str = url.getFile().substring(1);
                if (new File(str).exists()) {
                    existing.add(url);
                    continue;
                }
                if (!UtilLog.LOG.isDebugEnabled()) continue;
                UtilLog.LOG.debug("Resource file " + url + " not found.");
                continue;
            }
            existing.add(url);
        }
        return existing;
    }
}

