/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.source.resource.core;

import java.util.LinkedList;
import org.specrunner.SRServices;
import org.specrunner.source.ISource;
import org.specrunner.source.resource.EType;
import org.specrunner.source.resource.IResource;
import org.specrunner.source.resource.IResourceManager;
import org.specrunner.source.resource.ResourceException;
import org.specrunner.source.resource.positional.Position;
import org.specrunner.source.resource.positional.core.CSSResource;
import org.specrunner.source.resource.positional.core.JSResource;
import org.specrunner.util.UtilLog;

public class ResourceManagerImpl
extends LinkedList<IResource>
implements IResourceManager {
    private ISource parent;

    public ResourceManagerImpl(ISource parent) {
        this.parent = parent;
    }

    @Override
    public ISource getParent() {
        return this.parent;
    }

    public void setParent(ISource parent) {
        this.parent = parent;
    }

    @Override
    public void addDefaultCss() throws ResourceException {
        this.addCss("css/specrunner.css", true, EType.BINARY, Position.HEAD_START);
        if (UtilLog.LOG.isDebugEnabled()) {
            this.addCss("css/specrunner_debug.css", true, EType.BINARY, Position.HEAD_START);
        }
    }

    @Override
    public void addDefaultJs() throws ResourceException {
        this.addJs("js/jquery.js", true, EType.BINARY, Position.HEAD_END);
        this.addJs("js/specrunner.js", true, EType.BINARY, Position.HEAD_END);
    }

    @Override
    public boolean add(IResource resource) {
        boolean result = false;
        if (!this.contains(resource)) {
            result = super.add(resource);
            resource.setParent(this.getParent());
        }
        return result;
    }

    @Override
    public IResource addCss(String path, boolean classpath, EType ref) throws ResourceException {
        return this.check(new CSSResource(this.parent, path, classpath, ref, Position.HEAD_END));
    }

    @Override
    public IResource addCss(String path, boolean classpath, EType ref, Position position) throws ResourceException {
        return this.check(new CSSResource(this.parent, path, classpath, ref, position));
    }

    private IResource check(IResource result) {
        if (((Boolean)SRServices.getFeatureManager().get(FEATURE_ADD_RESOURCES, DEFAULT_ADD_RESOURCES)).booleanValue() && this.add(result)) {
            return result;
        }
        return null;
    }

    @Override
    public IResource addJs(String path, boolean classpath, EType ref) throws ResourceException {
        return this.check(new JSResource(this.parent, path, classpath, ref, Position.HEAD_END));
    }

    @Override
    public IResource addJs(String path, boolean classpath, EType ref, Position position) throws ResourceException {
        return this.check(new JSResource(this.parent, path, classpath, ref, position));
    }

    @Override
    public void merge(IResourceManager resources) {
        for (IResource r : resources) {
            this.add(r);
        }
    }
}

