/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.source.resource.element.core;

import java.io.File;
import java.net.URL;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.SRServices;
import org.specrunner.source.ISource;
import org.specrunner.source.resource.EType;
import org.specrunner.source.resource.ResourceException;
import org.specrunner.source.resource.element.core.AbstractResourceElement;
import org.specrunner.util.UtilIO;
import org.specrunner.util.UtilLog;
import org.specrunner.util.resources.ResourceFinder;

public abstract class AbstractResourceElementAtt
extends AbstractResourceElement {
    private String attribute;
    private String prefix;

    public AbstractResourceElementAtt(ISource parent, String path, boolean classpath, EType type, Element element, String reference, String prefix) {
        super(parent, path, classpath, type, element);
        this.attribute = reference;
        this.prefix = prefix;
    }

    @Override
    public ISource writeTo(ISource target) throws ResourceException {
        block4: {
            try {
                File fout = null;
                URL url = null;
                if (this.isClasspath()) {
                    url = SRServices.get(ResourceFinder.class).getSpecific(this.getResourcePath());
                    File f = new File(this.getResourcePath());
                    fout = new File(target.getFile().getParentFile(), target.getFile().getName() + "_res/" + f.getName());
                } else {
                    url = new URL(this.getResourcePath());
                    String srcChanged = this.getElement().getAttribute(this.getReferenceName()).getValue();
                    fout = new File(target.getFile().getParentFile(), srcChanged);
                }
                UtilIO.writeToClose(url, fout);
            }
            catch (Exception e) {
                if (!UtilLog.LOG.isDebugEnabled()) break block4;
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
        return target;
    }

    protected String getReferenceName() {
        return this.attribute;
    }

    @Override
    public String asString() {
        return this.getPrefix() + "(" + this.getResourcePath() + ")";
    }

    protected String getPrefix() {
        return this.prefix;
    }

    @Override
    public Node asNode() {
        Element e = (Element)this.getElement().copy();
        e.addAttribute(new Attribute(this.getReferenceName(), this.getResourcePath()));
        this.appendChild(e);
        return e;
    }

    protected void appendChild(Element root) {
        root.appendChild((Node)new Comment(" comment "));
    }
}

