/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.source.resource.positional.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.specrunner.source.ISource;
import org.specrunner.source.SourceException;
import org.specrunner.source.core.UtilEncoding;
import org.specrunner.source.resource.EType;
import org.specrunner.source.resource.ResourceException;
import org.specrunner.source.resource.positional.EPlace;
import org.specrunner.source.resource.positional.Position;
import org.specrunner.source.resource.positional.core.AbstractResourcePositional;
import org.specrunner.util.UtilIO;

public abstract class AbstractResourceHeader
extends AbstractResourcePositional {
    private static ThreadLocal<Integer> serialNumber = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    protected AbstractResourceHeader(ISource parent, String path, boolean classpath, EType type, Position position) {
        super(parent, path, classpath, type, position);
    }

    @Override
    public ISource writeTo(ISource output) throws ResourceException {
        block12: {
            try {
                Document doc = this.getParent().getDocument();
                Nodes places = doc.query(this.getPosition().getXpath());
                if (places.size() == 0) {
                    places = doc.query("//html");
                }
                if (places.size() > 0 && places.get(0) instanceof Element) {
                    Element target = (Element)places.get(0);
                    List<URL> urls = this.getResourceURLs();
                    if (this.getType() == EType.TEXT) {
                        Element tag = this.getHeaderTag();
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        UtilIO.writeAllTo(urls, out);
                        String content = out.toString(UtilEncoding.getEncoding());
                        out.close();
                        tag.appendChild(content.replace("\r\n", "\n"));
                        if (this.getPosition().getPlace() == EPlace.START) {
                            target.insertChild((Node)tag, 0);
                        } else {
                            target.appendChild((Node)tag);
                        }
                    } else {
                        for (URL url : urls) {
                            String protocol = url.getProtocol();
                            if (protocol == null || protocol.toLowerCase().startsWith("http")) continue;
                            String file = url.toString();
                            String name = file.substring(file.lastIndexOf(47) + 1) + "_res_" + serialNumber.get();
                            serialNumber.set(serialNumber.get() + 1);
                            Element tag = this.getHeaderTag(output, name);
                            File resFile = this.getFile(output, name);
                            if (!resFile.getParentFile().exists() && !resFile.getParentFile().mkdirs()) {
                                throw new ResourceException("Could not create resource directory '" + resFile.getParent() + "'.");
                            }
                            UtilIO.writeToClose(url, resFile);
                            if (this.getPosition().getPlace() == EPlace.START) {
                                target.insertChild((Node)tag, 0);
                                continue;
                            }
                            target.appendChild((Node)tag);
                        }
                    }
                    break block12;
                }
                throw new ResourceException("Head element not found.");
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
            catch (SourceException e) {
                throw new ResourceException(e);
            }
        }
        return output;
    }

    protected abstract Element getHeaderTag();

    protected abstract Element getHeaderTag(ISource var1, String var2);

    protected abstract File getFile(ISource var1, String var2);

    @Override
    public String asString() {
        return null;
    }

    @Override
    public Node asNode() {
        return null;
    }

    public String toString() {
        return "AbstractResourceHeader [path=" + this.getResourcePath() + ",type=" + (Object)((Object)this.getType()) + ", position=" + this.getPosition() + "]";
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractResourceHeader)) {
            return false;
        }
        AbstractResourceHeader arh = (AbstractResourceHeader)obj;
        return this.getResourcePath().equals(arh.getResourcePath()) && this.isClasspath() == arh.isClasspath() && this.getType() == arh.getType() && this.getPosition() == arh.getPosition();
    }
}

