/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.util;

import org.specrunner.SRServices;
import org.specrunner.SpecRunnerException;
import org.specrunner.context.IContext;
import org.specrunner.expressions.IExpression;
import org.specrunner.plugins.PluginException;
import org.specrunner.util.UtilLog;

public final class UtilEvaluator {
    public static final char ESCAPE = '\\';
    public static final String START_CODE = "${";
    public static final String END = "}";
    public static final String START_DATA = "#{";

    private UtilEvaluator() {
    }

    public static String asExpression(String content) {
        return START_CODE + content + END;
    }

    public static Object evaluate(String text, IContext context, boolean silent) throws PluginException {
        if (text == null) {
            return null;
        }
        IExpression expression = null;
        Object result = text;
        int pos1 = text.indexOf(START_CODE);
        int pos2 = text.indexOf(END, pos1 + 2);
        if (pos1 < 0 && pos2 < 0) {
            try {
                expression = SRServices.getExpressionFactory().create(text, context);
                result = expression.evaluate(context, silent);
            }
            catch (SpecRunnerException e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                throw new PluginException(e);
            }
        }
        while (pos1 >= 0 & pos2 > pos1) {
            if (pos1 > 0 && text.charAt(pos1 - 1) == '\\') {
                pos1 = text.indexOf(START_CODE, pos2 + 1);
                pos2 = text.indexOf(END, pos1 + 2);
                continue;
            }
            String content = text.substring(pos1 + 2, pos2);
            String name = START_CODE + content + END;
            try {
                expression = SRServices.getExpressionFactory().create(content, context);
                Object local = expression.evaluate(context);
                if (local != null) {
                    result = UtilEvaluator.replace(String.valueOf(result), name, local);
                }
            }
            catch (SpecRunnerException e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                throw new PluginException(e);
            }
            pos1 = text.indexOf(START_CODE, pos2 + 1);
            pos2 = text.indexOf(END, pos1 + 2);
        }
        return result;
    }

    public static String replace(String text, IContext context, boolean silent) throws PluginException {
        String result = text;
        int pos1 = text.indexOf(START_CODE);
        int pos2 = text.indexOf(END, pos1 + 2);
        while (pos1 >= 0 & pos2 > pos1) {
            if (pos1 > 0 && text.charAt(pos1 - 1) == '\\') {
                pos1 = text.indexOf(START_CODE, pos2 + 1);
                pos2 = text.indexOf(END, pos1 + 2);
                continue;
            }
            String content = text.substring(pos1 + 2, pos2);
            try {
                IExpression expression = SRServices.getExpressionFactory().create(content, context);
                Object local = expression.evaluate(context, silent);
                if (local != null) {
                    String name = START_CODE + content + END;
                    result = UtilEvaluator.replace(result, name, local);
                }
            }
            catch (SpecRunnerException e) {
                throw new PluginException("Error evaluating expression: " + content, e);
            }
            pos1 = text.indexOf(START_CODE, pos2 + 1);
            pos2 = text.indexOf(END, pos1 + 2);
        }
        return result;
    }

    public static String replace(String text, String name, Object local) {
        StringBuilder sb = new StringBuilder();
        int pos1 = 0;
        int pos2 = text.indexOf(name);
        while (pos1 >= 0 && pos2 >= 0) {
            sb.append(text.substring(pos1, pos2));
            if (pos2 > 0 && text.charAt(pos2 - 1) == '\\') {
                sb.append(name);
            } else {
                sb.append(String.valueOf(local));
            }
            pos1 = pos2 + name.length();
            pos2 = text.indexOf(name, pos1);
        }
        sb.append(text.substring(pos1, text.length()));
        return sb.toString();
    }
}

