/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import org.specrunner.SRServices;
import org.specrunner.concurrency.IConcurrentMapping;
import org.specrunner.source.resource.ResourceException;
import org.specrunner.util.UtilLog;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheFactory;

public final class UtilIO {
    protected static ICache<URL, byte[]> cache = SRServices.get(ICacheFactory.class).newCache(UtilIO.class.getName());
    public static final int BUFFER_SIZE = 1024;
    private static final int READ_SIZE = 12;

    private UtilIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAllTo(List<URL> files, OutputStream out) throws ResourceException {
        block15: {
            InputStream[] ins = null;
            int i = 0;
            try {
                for (InputStream in : ins = UtilIO.getInputStreams(files)) {
                    UtilIO.writeTo(in, out);
                    in.close();
                    ins[i] = null;
                    ++i;
                }
            }
            catch (IOException e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                if (ins == null) break block15;
                for (int j = 0; j < i; ++j) {
                    try {
                        if (UtilLog.LOG.isDebugEnabled()) {
                            UtilLog.LOG.debug("Closing " + ins[j]);
                        }
                        if (ins[j] == null) continue;
                        ins[j].close();
                        continue;
                    }
                    catch (IOException e) {
                        if (!UtilLog.LOG.isDebugEnabled()) continue;
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public static InputStream[] getInputStreams(List<URL> files) throws ResourceException {
        InputStream[] result = new InputStream[files.size()];
        int i = 0;
        try {
            for (URL url : files) {
                result[i++] = UtilIO.getStream(url);
            }
        }
        catch (IOException e) {
            for (int j = 0; j < i; ++j) {
                try {
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug("Closing " + files.get(j));
                    }
                    result[j].close();
                    continue;
                }
                catch (IOException e1) {
                    if (!UtilLog.LOG.isDebugEnabled()) continue;
                    UtilLog.LOG.debug(e1.getMessage(), (Throwable)e1);
                }
            }
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new ResourceException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getStream(URL url) throws IOException {
        ICache<URL, byte[]> iCache = cache;
        synchronized (iCache) {
            byte[] data = cache.get(url);
            if (data != null) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Stream reused for: " + url);
                }
                return new ByteArrayInputStream(data);
            }
            InputStream in = null;
            ByteArrayOutputStream out = null;
            try {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Stream open: " + url);
                }
                in = url.openStream();
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Stream loaded: " + in);
                }
                out = new ByteArrayOutputStream(in.available());
                UtilIO.writeTo(in, out);
                data = out.toByteArray();
                cache.put(url, data);
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Stream with '" + data.length + "' bytes cached for: " + url);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        if (UtilLog.LOG.isDebugEnabled()) {
                            UtilLog.LOG.debug("Closing " + in, (Throwable)e);
                        }
                        throw e;
                    }
                }
                if (out != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        if (UtilLog.LOG.isDebugEnabled()) {
                            UtilLog.LOG.debug("Closing " + in, (Throwable)e);
                        }
                        throw e;
                    }
                }
            }
            return new ByteArrayInputStream(data);
        }
    }

    public static void writeTo(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int size = 0;
        while ((size = in.read(buffer)) > 0) {
            out.write(buffer, 0, size);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToClose(URL url, File file) throws IOException {
        long time = System.currentTimeMillis();
        InputStream in = null;
        FileOutputStream fout = null;
        FilterOutputStream bout = null;
        try {
            in = UtilIO.getStream(url);
            fout = new FileOutputStream(file);
            bout = new BufferedOutputStream(fout);
            UtilIO.writeTo(in, bout);
        }
        finally {
            block22: {
                block21: {
                    block20: {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception e) {
                                if (!UtilLog.LOG.isDebugEnabled()) break block20;
                                UtilLog.LOG.debug("Closing " + in, (Throwable)e);
                            }
                        }
                    }
                    if (fout != null) {
                        try {
                            fout.close();
                        }
                        catch (Exception e) {
                            if (!UtilLog.LOG.isDebugEnabled()) break block21;
                            UtilLog.LOG.debug("Closing " + fout, (Throwable)e);
                        }
                    }
                }
                if (bout != null) {
                    try {
                        bout.close();
                    }
                    catch (Exception e) {
                        if (!UtilLog.LOG.isDebugEnabled()) break block22;
                        UtilLog.LOG.debug("Closing " + bout, (Throwable)e);
                    }
                }
            }
        }
        if (UtilLog.LOG.isDebugEnabled()) {
            time = System.currentTimeMillis() - time;
            UtilLog.LOG.debug("After writeToClose time:" + time + ".");
        }
    }

    public static void pressKey() throws IOException {
        IConcurrentMapping cm = SRServices.get(IConcurrentMapping.class);
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("(" + cm.getThread() + ") read keybord (press 'Enter' to go on)...");
        }
        int count = System.in.read(new byte[12]);
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("(" + cm.getThread() + ") done..." + count);
        }
    }
}

