/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.util;

import nu.xom.Document;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import org.specrunner.source.ISource;
import org.specrunner.source.SourceException;
import org.specrunner.source.resource.ResourceException;
import org.specrunner.source.resource.positional.IResourcePositional;

public final class UtilResources {
    private UtilResources() {
    }

    public static void addToDoc(ISource source, IResourcePositional resourcePositional) throws ResourceException {
        try {
            Document d = source.getDocument();
            Nodes ns = d.query(resourcePositional.getPosition().getXpath());
            if (ns.size() > 0) {
                Node n = ns.get(0);
                ParentNode p = n.getParent();
                Node a = resourcePositional.asNode();
                switch (resourcePositional.getPosition().getPlace()) {
                    case BEFORE: {
                        p.insertChild(a, p.indexOf(n));
                        break;
                    }
                    case AFTER: {
                        p.insertChild(a, p.indexOf(n) + 1);
                        break;
                    }
                    case START: {
                        if (!(n instanceof ParentNode)) break;
                        ((ParentNode)n).insertChild(a, 0);
                        break;
                    }
                    case END: {
                        if (!(n instanceof ParentNode)) break;
                        ((ParentNode)n).appendChild(a);
                        break;
                    }
                }
            }
        }
        catch (SourceException e) {
            throw new ResourceException(e);
        }
    }
}

