/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.util;

import java.text.Normalizer;

public final class UtilString {
    private UtilString() {
    }

    public static String normalize(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c) || !Character.isDefined(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String camelCase(String text) {
        return UtilString.camelCase(text, false);
    }

    public static String camelCase(String text, boolean changeFirst) {
        if (text == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean whitespace = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                whitespace = true;
                continue;
            }
            if (result.length() == 0 && Character.isJavaIdentifierStart(c)) {
                if (changeFirst) {
                    result.append(Character.toUpperCase(c));
                    continue;
                }
                result.append(Character.toLowerCase(c));
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) continue;
            if (whitespace) {
                result.append(Character.toUpperCase(c));
                whitespace = false;
                continue;
            }
            result.append(Character.toLowerCase(c));
        }
        return UtilString.clean(result.toString());
    }

    public static String clean(String str) {
        return Normalizer.normalize(str, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }
}

