/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.util.aligner.core;

import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.SRServices;
import org.specrunner.util.aligner.AlignmentException;
import org.specrunner.util.aligner.IStringAligner;
import org.specrunner.util.aligner.IStringAlignerFactory;

public class DefaultAlignmentException
extends AlignmentException {
    public DefaultAlignmentException(String message, String expected, String received) {
        super(message, SRServices.get(IStringAlignerFactory.class).align(expected, received));
    }

    public DefaultAlignmentException(String expected, String received) {
        super("Strings are different:", SRServices.get(IStringAlignerFactory.class).align(expected, received));
    }

    public DefaultAlignmentException(String message, IStringAligner aligner) {
        super(message, aligner);
    }

    @Override
    public String asString() {
        return this.getMessage();
    }

    @Override
    public Node asNode() {
        Element ele = new Element("table");
        ele.addAttribute(new Attribute("class", "alignment"));
        Element tr = new Element("tr");
        ele.appendChild((Node)tr);
        Element td = new Element("td");
        td.addAttribute(new Attribute("class", "expected"));
        Element inner = new Element("span");
        inner.addAttribute(new Attribute("class", "small_expected"));
        inner.appendChild("(expected)");
        td.appendChild((Node)inner);
        td.appendChild(this.aligner.getExpected());
        tr.appendChild((Node)td);
        tr = new Element("tr");
        ele.appendChild((Node)tr);
        td = new Element("td");
        td.addAttribute(new Attribute("class", "received"));
        inner = new Element("span");
        inner.addAttribute(new Attribute("class", "small_received"));
        inner.appendChild("(received)");
        td.appendChild((Node)inner);
        td.appendChild(this.aligner.getReceived());
        tr.appendChild((Node)td);
        tr = new Element("tr");
        ele.appendChild((Node)tr);
        td = new Element("td");
        tr.appendChild((Node)td);
        this.addDetail(td);
        return ele;
    }

    protected void addDetail(Element e) {
        Element td = e;
        Element input = new Element("input");
        String buttonId = "alg_" + System.currentTimeMillis() + "_" + System.nanoTime();
        input.addAttribute(new Attribute("type", "button"));
        input.addAttribute(new Attribute("id", buttonId));
        input.addAttribute(new Attribute("value", " + "));
        input.addAttribute(new Attribute("class", "collapsable"));
        td.appendChild((Node)input);
        this.addTable(td, buttonId);
    }

    private void addTable(Element td, String buttonId) {
        Element tr = new Element("tr");
        Element table = new Element("table");
        table.addAttribute(new Attribute("class", "comparator"));
        table.addAttribute(new Attribute("id", buttonId + "_ref"));
        td.appendChild((Node)table);
        table.appendChild((Node)tr);
        this.addLabels(tr);
        this.addComparison(tr);
    }

    private void addLabels(Element tr) {
        Element td = new Element("td");
        for (int i = 0; i < 2; ++i) {
            Element span = new Element("span");
            span.addAttribute(new Attribute("class", "expected"));
            Element inner = new Element("span");
            inner.addAttribute(new Attribute("class", "small_expected"));
            inner.appendChild("(expected)");
            span.appendChild((Node)inner);
            td.appendChild((Node)span);
            td.appendChild((Node)new Element("hr"));
            span = new Element("span");
            span.addAttribute(new Attribute("class", "received"));
            inner = new Element("span");
            inner.addAttribute(new Attribute("class", "small_received"));
            inner.appendChild("(received)");
            span.appendChild((Node)inner);
            td.appendChild((Node)span);
            if (i != 0) continue;
            td.appendChild((Node)new Element("hr"));
        }
        tr.appendChild((Node)td);
    }

    private void addComparison(Element tr) {
        StringBuilder a = this.aligner.getExpectedAligned();
        StringBuilder b = this.aligner.getReceivedAligned();
        StringBuilder aT = new StringBuilder();
        StringBuilder bT = new StringBuilder();
        int i = 0;
        while (i < a.length()) {
            aT.setLength(0);
            bT.setLength(0);
            while (i < a.length() && a.charAt(i) == b.charAt(i)) {
                aT.append(a.charAt(i));
                bT.append(b.charAt(i));
                ++i;
            }
            if (aT.length() > 0) {
                this.addEquals(tr, aT, bT);
            }
            aT.setLength(0);
            bT.setLength(0);
            while (i < a.length() && a.charAt(i) != b.charAt(i)) {
                aT.append(a.charAt(i));
                bT.append(b.charAt(i));
                ++i;
            }
            if (aT.length() <= 0) continue;
            for (int j = 0; j < aT.length(); ++j) {
                this.addNotEquals(j, tr, aT, bT);
            }
        }
    }

    protected void addEquals(Element tr, StringBuilder aT, StringBuilder bT) {
        Element equals = new Element("td");
        equals.addAttribute(new Attribute("class", "equals"));
        equals.appendChild(aT.toString());
        equals.appendChild((Node)new Element("hr"));
        equals.appendChild(bT.toString());
        equals.appendChild((Node)new Element("hr"));
        equals.appendChild(aT.toString());
        equals.appendChild((Node)new Element("hr"));
        equals.appendChild(bT.toString());
        tr.appendChild((Node)equals);
    }

    protected void addNotEquals(int j, Element tr, StringBuilder aT, StringBuilder bT) {
        Element span;
        Element notEquals = new Element("td");
        notEquals.addAttribute(new Attribute("class", "notequals"));
        notEquals.appendChild(aT.charAt(j) + "");
        notEquals.appendChild((Node)new Element("hr"));
        notEquals.appendChild(bT.charAt(j) + "");
        notEquals.appendChild((Node)new Element("hr"));
        notEquals.appendChild(aT.charAt(j) + "");
        if (aT.charAt(j) != this.aligner.getFillCharacter()) {
            span = new Element("span");
            span.addAttribute(new Attribute("class", "code"));
            span.appendChild("" + aT.charAt(j));
            notEquals.appendChild((Node)span);
        }
        notEquals.appendChild((Node)new Element("hr"));
        notEquals.appendChild(bT.charAt(j) + "");
        if (bT.charAt(j) != this.aligner.getFillCharacter()) {
            span = new Element("span");
            span.addAttribute(new Attribute("class", "code"));
            span.appendChild("" + bT.charAt(j));
            notEquals.appendChild((Node)span);
        }
        tr.appendChild((Node)notEquals);
    }
}

