/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.util.aligner.core;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.specrunner.util.UtilLog;
import org.specrunner.util.aligner.IStringAligner;

public class NeedlemanWunschAligner
implements IStringAligner {
    protected String expected;
    protected StringBuilder expectedAligned;
    protected char fillCharacter;
    protected String received;
    protected StringBuilder receivedAligned;

    public NeedlemanWunschAligner(String expected, String received) {
        this(expected, received, '-');
    }

    public NeedlemanWunschAligner(String expected, String received, char fillCharacter) {
        this.expected = expected;
        this.received = received;
        this.fillCharacter = fillCharacter;
    }

    @Override
    public String getExpected() {
        return this.expected;
    }

    @Override
    public StringBuilder getExpectedAligned() {
        if (this.expectedAligned == null) {
            this.align();
        }
        return this.expectedAligned;
    }

    @Override
    public char getFillCharacter() {
        return this.fillCharacter;
    }

    @Override
    public String getReceived() {
        return this.received;
    }

    @Override
    public StringBuilder getReceivedAligned() {
        if (this.receivedAligned == null) {
            this.align();
        }
        return this.receivedAligned;
    }

    protected void align() {
        List<Character> list = this.alphabet(this.expected, this.received);
        int size = list.size();
        if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("ALFABETH(" + size + ")>" + list);
        }
        int[][] s = this.scoring(size);
        if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("SCORING>\n" + this.toString(s));
        }
        int d = this.penalty(size);
        if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("PENALTY>" + d);
        }
        int[][] f = this.calculate(this.expected, this.received, list, s, d);
        if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("CALCULATE>\n" + this.toString(f));
        }
        this.traceback(this.expected, this.received, list, s, d, f);
        if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("EXPECTED>" + this.getExpectedAligned());
            UtilLog.LOG.trace("RECEIVED>" + this.getReceivedAligned());
        }
    }

    protected List<Character> alphabet(String a, String b) {
        int i;
        LinkedList<Character> list = new LinkedList<Character>();
        for (i = 0; i < a.length(); ++i) {
            if (list.contains(Character.valueOf(a.charAt(i)))) continue;
            list.add(Character.valueOf(a.charAt(i)));
        }
        for (i = 0; i < b.length(); ++i) {
            if (list.contains(Character.valueOf(b.charAt(i)))) continue;
            list.add(Character.valueOf(b.charAt(i)));
        }
        Collections.sort(list);
        return list;
    }

    protected int[][] calculate(String a, String b, List<Character> list, int[][] s, int d) {
        int i;
        int[][] f = new int[a.length() + 1][b.length() + 1];
        for (i = 0; i < a.length(); ++i) {
            f[i][0] = d * i;
        }
        for (i = 0; i < b.length(); ++i) {
            f[0][i] = d * i;
        }
        for (i = 1; i < a.length() + 1; ++i) {
            for (int j = 1; j < b.length() + 1; ++j) {
                int match = f[i - 1][j - 1] + s[list.indexOf(Character.valueOf(a.charAt(i - 1)))][list.indexOf(Character.valueOf(b.charAt(j - 1)))];
                int delete = f[i - 1][j] + d;
                int insert = f[i][j - 1] + d;
                f[i][j] = Math.max(match, Math.max(insert, delete));
            }
        }
        return f;
    }

    protected int[][] scoring(int size) {
        int[][] s = new int[size][size];
        for (int i = 0; i < s.length; ++i) {
            for (int j = 0; j < s[i].length; ++j) {
                s[i][j] = i == j ? size / 2 : (i < j ? s[i][j - 1] - 1 : s[i - 1][j] - 1);
            }
        }
        return s;
    }

    protected int penalty(int size) {
        return -(size / 2);
    }

    protected void traceback(String a, String b, List<Character> list, int[][] s, int d, int[][] f) {
        StringBuilder alignmentA = new StringBuilder();
        StringBuilder alignmentB = new StringBuilder();
        int i = a.length();
        int j = b.length();
        while (i > 0 && j > 0) {
            int score = f[i][j];
            int scoreDiag = f[i - 1][j - 1];
            int scoreUp = f[i][j - 1];
            int scoreLeft = f[i - 1][j];
            if (score == scoreDiag + s[list.indexOf(Character.valueOf(a.charAt(i - 1)))][list.indexOf(Character.valueOf(b.charAt(j - 1)))]) {
                alignmentA.append(a.charAt(--i));
                alignmentB.append(b.charAt(--j));
                continue;
            }
            if (score == scoreLeft + d) {
                alignmentA.append(a.charAt(--i));
                alignmentB.append(this.fillCharacter);
                continue;
            }
            if (score == scoreUp + d) {
                alignmentA.append(this.fillCharacter);
                alignmentB.append(b.charAt(--j));
                continue;
            }
            throw new IllegalArgumentException("Fail!");
        }
        while (0 < i) {
            alignmentA.append(a.charAt(--i));
            alignmentB.append(this.fillCharacter);
        }
        while (0 < j) {
            alignmentA.append(this.fillCharacter);
            alignmentB.append(b.charAt(--j));
        }
        this.expectedAligned = alignmentA.reverse();
        this.receivedAligned = alignmentB.reverse();
    }

    protected String toString(int[][] d) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < d.length; ++i) {
            for (int j = 0; j < d[i].length; ++j) {
                sb.append(String.format("%s%4d", j == 0 ? "\t" : ",", d[i][j]));
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

