/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.util.cache;

public class CacheEntry<K, T>
implements Comparable<CacheEntry<K, T>> {
    private long timestamp = System.currentTimeMillis();
    private K key;
    private T value;

    public CacheEntry(K key, T value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value;
    }

    public void renew() {
        this.timestamp = System.currentTimeMillis();
    }

    public boolean invalid(long timeout) {
        return this.timestamp + timeout < System.currentTimeMillis();
    }

    @Override
    public int compareTo(CacheEntry<K, T> o) {
        return (int)(this.timestamp - o.timestamp);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CacheEntry ? this.key.equals(((CacheEntry)obj).key) : false;
    }
}

