/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.util.cache.core;

import org.specrunner.SRServices;
import org.specrunner.features.IFeatureManager;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheCleaner;
import org.specrunner.util.cache.ICacheFactory;

public abstract class AbstractCacheFactory
implements ICacheFactory {
    @Override
    public <K, T> ICache<K, T> newCache(String name) {
        return this.create(name, new ICacheCleaner<T>(){

            @Override
            public void destroy(T obj) {
            }
        });
    }

    @Override
    public <K, T> ICache<K, T> newCache(String name, ICacheCleaner<T> cleaner) {
        IFeatureManager fm = SRServices.getFeatureManager();
        ICache<K, T> cache = this.create(name, cleaner);
        fm.set(ICache.FEATURE_TIMEOUT, cache);
        fm.set(ICache.FEATURE_SIZE, cache);
        fm.set(ICache.FEATURE_CLEAN, cache);
        return cache;
    }

    protected abstract <K, T> ICache<K, T> create(String var1, ICacheCleaner<T> var2);
}

