/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.util.cache.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.specrunner.util.UtilLog;
import org.specrunner.util.cache.CacheEntry;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheCleaner;

public class CacheLRU<K, T>
implements ICache<K, T> {
    private String name;
    private long timeout = 300000L;
    private long size = 100L;
    private long clean = 50L;
    private Map<K, CacheEntry<K, T>> items = new HashMap<K, CacheEntry<K, T>>();
    private ICacheCleaner<T> cleaner;

    public CacheLRU(String name, ICacheCleaner<T> cleaner) {
        this.name = name;
        this.cleaner = cleaner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ICache<K, T> setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ICacheCleaner<T> getCleaner() {
        return this.cleaner;
    }

    @Override
    public ICache<K, T> setCleaner(ICacheCleaner<T> cleaner) {
        this.cleaner = cleaner;
        return this;
    }

    @Override
    public ICache<K, T> setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public ICache<K, T> setSize(long size) {
        this.size = size;
        return this;
    }

    @Override
    public ICache<K, T> setClean(long clean) {
        this.clean = clean;
        return this;
    }

    @Override
    public boolean contains(K key) {
        return this.items.containsKey(key);
    }

    @Override
    public T get(K key) {
        CacheEntry<K, T> item = this.items.get(key);
        if (item != null) {
            if (!item.invalid(this.timeout)) {
                item.renew();
                if (UtilLog.LOG.isTraceEnabled()) {
                    UtilLog.LOG.trace("Cache '" + this.name + "' hit: " + key);
                }
                return item.getValue();
            }
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("Cache '" + this.name + "' expired: " + key);
            }
            this.cleaner.destroy(this.items.remove(item.getKey()).getValue());
        }
        return null;
    }

    @Override
    public ICache<K, T> put(K key, T value) {
        if ((long)this.items.size() > this.size) {
            TreeSet<CacheEntry<K, T>> set = new TreeSet<CacheEntry<K, T>>(this.items.values());
            int index = 0;
            Iterator ite = set.iterator();
            while ((long)index++ < this.clean && ite.hasNext()) {
                CacheEntry next = (CacheEntry)ite.next();
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Cache '" + this.name + "' clean: " + next.getKey());
                }
                this.remove(next.getKey());
            }
        }
        this.items.put(key, new CacheEntry<K, T>(key, value));
        return this;
    }

    @Override
    public void remove(K key) {
        CacheEntry<K, T> entry = this.items.remove(key);
        if (entry != null) {
            this.cleaner.destroy(entry.getValue());
        }
    }

    @Override
    public void release() {
        for (CacheEntry<K, T> entry : this.items.values()) {
            this.cleaner.destroy(entry.getValue());
        }
        this.items.clear();
    }
}

