/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.util.mapping.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.specrunner.SRServices;
import org.specrunner.properties.IPropertyLoader;
import org.specrunner.util.UtilLog;
import org.specrunner.util.mapping.IMappingManager;
import org.specrunner.util.mapping.IResetable;

public abstract class MappingManagerImpl<T extends IResetable>
extends HashMap<String, T>
implements IMappingManager<T> {
    private String file;
    protected boolean initialized = false;

    public MappingManagerImpl(String file) {
        this.file = file;
    }

    public void initialize() {
        if (!this.initialized) {
            try {
                long time = System.currentTimeMillis();
                List<Properties> list = SRServices.get(IPropertyLoader.class).load(this.file);
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("properties list=" + list);
                }
                for (Properties p : list) {
                    HashMap<String, IResetable> instances = new HashMap<String, IResetable>();
                    for (Map.Entry<Object, Object> e : p.entrySet()) {
                        String key = String.valueOf(e.getKey());
                        String property = p.getProperty(key);
                        String keyNormalized = this.normalizeKey(key);
                        IResetable instance = (IResetable)instances.get(property);
                        if (instance == null) {
                            Class<?> c = Class.forName(property);
                            instance = (IResetable)c.newInstance();
                            if (UtilLog.LOG.isDebugEnabled()) {
                                UtilLog.LOG.debug("put(" + keyNormalized + "," + instance + "[of type " + c + "])");
                            }
                        } else if (UtilLog.LOG.isDebugEnabled()) {
                            UtilLog.LOG.debug("reuse.put(" + keyNormalized + "," + instance + ")");
                        }
                        this.put(keyNormalized, instance);
                        instances.put(property, instance);
                    }
                }
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("LOAD TIME(" + this.file + "):" + (System.currentTimeMillis() - time));
                }
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
            this.initialized = true;
        }
    }

    protected String normalizeKey(Object key) {
        return key == null ? null : String.valueOf(key).toLowerCase();
    }

    @Override
    public IMappingManager<T> bind(String name, T obj) {
        this.initialize();
        this.put(name, obj);
        return this;
    }

    @Override
    public Set<String> keySet() {
        this.initialize();
        return super.keySet();
    }

    @Override
    public T get(Object name) {
        if (name == null) {
            return null;
        }
        this.initialize();
        IResetable c = (IResetable)super.get(this.normalizeKey(name));
        if (c != null) {
            c.initialize();
        }
        return (T)c;
    }

    @Override
    public T getDefault() {
        return (T)this.get("default");
    }

    @Override
    public void setDefault(T obj) {
        this.bind("default", obj);
    }
}

