/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.util.resources;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.specrunner.SRServices;
import org.specrunner.properties.core.PropertyLoaderImpl;
import org.specrunner.util.UtilLog;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheFactory;

public class ResourceFinder {
    public static final String FEATURE_COMPARATOR = ResourceFinder.class.getName() + ".comparator";
    protected static ICache<String, List<URL>> cache = SRServices.get(ICacheFactory.class).newCache(PropertyLoaderImpl.class.getName());
    private Comparator<URL> comparator;

    public Comparator<URL> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<URL> comparator) {
        this.comparator = comparator;
    }

    public String getDefault(String resource) {
        int pos = resource.lastIndexOf(46);
        return resource.substring(0, pos) + "_default" + resource.substring(pos);
    }

    public URL getSpecific(String resource) throws IOException {
        List<URL> files = this.getAllResources(resource);
        if (files.isEmpty()) {
            return null;
        }
        return files.get(files.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> getAllResources(String resource) throws IOException {
        this.comparator = null;
        SRServices.getFeatureManager().set(FEATURE_COMPARATOR, this);
        ICache<String, List<URL>> iCache = cache;
        synchronized (iCache) {
            List<URL> files = cache.get(resource);
            if (files != null) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Resource reused '" + resource + "' :" + files);
                }
                return this.filter(this.sort(new LinkedList<URL>(files)));
            }
            files = new LinkedList<URL>();
            String standard = this.getDefault(resource);
            files.addAll(this.getResources(standard));
            files.addAll(this.getResources(resource));
            if (UtilLog.LOG.isTraceEnabled()) {
                this.log("Resource list:", files);
            }
            files = this.filter(files);
            if (UtilLog.LOG.isTraceEnabled()) {
                this.log("Resource list filtered:", files);
            }
            files = this.sort(files);
            if (UtilLog.LOG.isTraceEnabled()) {
                this.log("Resource list sorted:", files);
            }
            cache.put(resource, files);
            return files;
        }
    }

    protected void log(String msg, List<URL> files) {
        UtilLog.LOG.trace(msg);
        for (URL url : files) {
            UtilLog.LOG.trace("\t" + url);
        }
    }

    public List<URL> getResources(String resource) throws IOException {
        LinkedList<URL> result = new LinkedList<URL>();
        Enumeration<URL> urls = ClassLoader.getSystemResources(resource);
        while (urls.hasMoreElements()) {
            result.add(urls.nextElement());
        }
        return result;
    }

    public List<URL> filter(List<URL> resources) {
        return resources;
    }

    public List<URL> sort(List<URL> resources) {
        if (this.comparator == null) {
            Collections.reverse(resources);
        } else {
            Collections.sort(resources, this.comparator);
        }
        return resources;
    }
}

