/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.util.xom;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.apache.commons.beanutils.PropertyUtils;
import org.specrunner.SRServices;
import org.specrunner.comparators.ComparatorException;
import org.specrunner.comparators.IComparator;
import org.specrunner.comparators.IComparatorManager;
import org.specrunner.context.IContext;
import org.specrunner.converters.IConverter;
import org.specrunner.converters.IConverterManager;
import org.specrunner.plugins.PluginException;
import org.specrunner.util.UtilEvaluator;
import org.specrunner.util.UtilLog;
import org.specrunner.util.xom.INodeHolder;

public class NodeHolder
implements INodeHolder {
    protected Node node;

    public NodeHolder(Node element) {
        this.node = element;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void setNode(Node element) {
        this.node = element;
    }

    @Override
    public String getQualifiedName() {
        if (this.node instanceof Element) {
            return ((Element)this.node).getQualifiedName();
        }
        return null;
    }

    @Override
    public boolean hasName(String name) {
        String tmp = this.getQualifiedName();
        return tmp != null && tmp.equalsIgnoreCase(name);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.node instanceof Element && ((Element)this.node).getAttribute(name) != null;
    }

    @Override
    public String getAttribute(String name) {
        return this.hasAttribute(name) ? ((Element)this.node).getAttribute(name).getValue() : null;
    }

    @Override
    public String getAttribute(String name, String defaultValue) {
        return this.hasAttribute(name) ? ((Element)this.node).getAttribute(name).getValue() : defaultValue;
    }

    @Override
    public void setAttribute(String name, String value) {
        if (this.hasAttribute(name)) {
            ((Element)this.node).getAttribute(name).setValue(value);
        } else if (this.node instanceof Element) {
            ((Element)this.node).addAttribute(new Attribute(name, value));
        }
    }

    @Override
    public void removeAttribute(String name) {
        if (this.node instanceof Element) {
            Element element = (Element)this.node;
            for (int i = 0; i < element.getAttributeCount(); ++i) {
                Attribute att = element.getAttribute(i);
                if (!att.getQualifiedName().equalsIgnoreCase(name)) continue;
                element.removeAttribute(att);
                break;
            }
        }
    }

    @Override
    public boolean attributeContains(String name, String value) {
        return this.hasAttribute(name) && this.getAttribute(name).contains(value);
    }

    @Override
    public boolean attributeEquals(String name, String value) {
        return this.hasAttribute(name) && this.getAttribute(name).equalsIgnoreCase(value);
    }

    @Override
    public String getValue() {
        return this.node.getValue();
    }

    @Override
    public void setValue(String text) {
        if (this.node instanceof Text) {
            ParentNode parent = this.node.getParent();
            int index = parent.indexOf(this.node);
            parent.removeChild(index);
            parent.insertChild((Node)new Text(text), index);
        } else if (this.node instanceof Element) {
            for (int i = this.node.getChildCount() - 1; i >= 0; --i) {
                this.node.getChild(i).detach();
            }
            ((Element)this.node).appendChild(text);
        }
    }

    @Override
    public void prepend(String text) {
        if (this.node instanceof Text) {
            ParentNode parent = this.node.getParent();
            int index = parent.indexOf(this.node);
            parent.insertChild((Node)new Text(text), Math.max(0, index - 1));
        } else if (this.node instanceof Element) {
            ((Element)this.node).insertChild(text, 0);
        }
    }

    @Override
    public void append(String text) {
        if (this.node instanceof Text) {
            ParentNode parent = this.node.getParent();
            int index = parent.indexOf(this.node);
            parent.insertChild((Node)new Text(text), index + 1);
        } else if (this.node instanceof Element) {
            ((Element)this.node).appendChild(text);
        }
    }

    @Override
    public IConverter getConverter() {
        return this.getConverter((IConverter)SRServices.getConverterManager().getDefault());
    }

    @Override
    public IConverter getConverter(IConverter converterDefault) {
        IConverter converter;
        block5: {
            converter = null;
            if (this.hasAttribute("converter")) {
                String str = this.getAttribute("converter");
                IConverterManager cm = SRServices.getConverterManager();
                converter = (IConverter)cm.get(str);
                if (converter == null) {
                    try {
                        converter = (IConverter)Class.forName(str).newInstance();
                        cm.bind(str, converter);
                    }
                    catch (Exception e) {
                        if (!UtilLog.LOG.isTraceEnabled()) break block5;
                        UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        if (converter == null) {
            converter = converterDefault;
        }
        return converter;
    }

    @Override
    public List<String> getArguments() {
        return this.getArguments(new LinkedList<String>());
    }

    @Override
    public List<String> getArguments(List<String> arguments) {
        LinkedList<String> params = new LinkedList<String>();
        if (this.node instanceof Element) {
            String arg;
            Element element = (Element)this.node;
            for (int i = 0; i < element.getAttributeCount() && (arg = this.getAttribute("arg" + i)) != null; ++i) {
                params.add(arg);
            }
        }
        return params.isEmpty() ? arguments : params;
    }

    @Override
    public IComparator getComparator() throws ComparatorException {
        return this.getComparator((IComparator)SRServices.getComparatorManager().getDefault());
    }

    @Override
    public IComparator getComparator(IComparator comparatorDefault) throws ComparatorException {
        IComparator comparator;
        block6: {
            comparator = null;
            if (this.hasAttribute("comparator")) {
                String str = this.getAttribute("comparator");
                IComparatorManager cm = SRServices.getComparatorManager();
                comparator = (IComparator)cm.get(str);
                if (comparator == null) {
                    try {
                        comparator = (IComparator)Class.forName(str).newInstance();
                        cm.bind(str, comparator);
                    }
                    catch (Exception e) {
                        if (UtilLog.LOG.isTraceEnabled()) {
                            UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                        }
                        if (comparatorDefault != null) break block6;
                        throw new ComparatorException(e);
                    }
                }
            }
        }
        if (comparator == null) {
            comparator = comparatorDefault;
        }
        return comparator;
    }

    @Override
    public Object getObject(IContext context, boolean silent) throws PluginException {
        return this.getObject(context, silent, this.getConverter(), this.getArguments());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(IContext context, boolean silent, IConverter converter, List<String> arguments) throws PluginException {
        boolean extend;
        boolean bl = extend = context.getNode() != this.node;
        if (extend) {
            context.push(context.newBlock(this.node, null));
            context.addMetadata();
        }
        try {
            converter = this.getConverter(converter);
            arguments = this.getArguments(arguments);
            Object value = null;
            if (this.attributeEquals("eval", Boolean.FALSE.toString())) {
                value = this.getValue();
                if (UtilLog.LOG.isTraceEnabled()) {
                    UtilLog.LOG.trace("Evaluation ignored, value is '" + value + "' of type " + (value != null ? value.getClass() : " null"));
                }
            } else {
                Object convert;
                if (this.hasAttribute("property")) {
                    String str = this.getAttribute("property");
                    int pos = str.indexOf(46);
                    if (pos <= 0) {
                        throw new PluginException("Bean name or property missing in property='" + str + "'.");
                    }
                    Object bean = UtilEvaluator.evaluate(str.substring(0, pos), context, silent);
                    try {
                        value = PropertyUtils.getProperty((Object)bean, (String)str.substring(pos + 1));
                    }
                    catch (IllegalAccessException e) {
                        throw new PluginException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new PluginException(e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new PluginException(e);
                    }
                    if (UtilLog.LOG.isTraceEnabled()) {
                        UtilLog.LOG.trace("Bean property (" + str + ") value is '" + value + "' of type " + (value != null ? value.getClass() : " null"));
                    }
                } else {
                    String tmp;
                    if (this.hasAttribute("value")) {
                        tmp = this.getAttribute("value");
                        if (UtilLog.LOG.isTraceEnabled()) {
                            UtilLog.LOG.trace("Attribute value present, value is '" + tmp + "'.");
                        }
                    } else {
                        tmp = this.getValue();
                        if (UtilLog.LOG.isTraceEnabled()) {
                            UtilLog.LOG.trace("Content value is '" + tmp + "'.");
                        }
                    }
                    value = UtilEvaluator.evaluate(tmp, context, silent);
                    if (UtilLog.LOG.isTraceEnabled()) {
                        UtilLog.LOG.trace("Evaluated value is '" + value + "' of type " + (value != null ? value.getClass() : " null"));
                    }
                }
                Object[] args = new Object[arguments.size()];
                for (int i = 0; i < arguments.size(); ++i) {
                    args[i] = UtilEvaluator.evaluate(arguments.get(i), context, silent);
                }
                try {
                    if (UtilLog.LOG.isTraceEnabled()) {
                        UtilLog.LOG.trace("Trying to convert '" + value + "' of type " + (value != null ? value.getClass() : " null") + " using " + converter + " with arguments: " + Arrays.toString(args));
                    }
                    convert = converter.convert(value, arguments.toArray());
                }
                catch (Exception e) {
                    throw new PluginException(e);
                }
                if (UtilLog.LOG.isTraceEnabled()) {
                    UtilLog.LOG.trace("Converted value is '" + value + "' of type " + (value != null ? value.getClass() : " null"));
                }
                Object object = convert;
                return object;
            }
            String string = value;
            return string;
        }
        finally {
            if (extend) {
                context.pop();
            }
        }
    }

    public String toString() {
        return this.getNode() != null ? this.getNode().toXML() : "null";
    }
}

