/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.util.xom;

import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import org.specrunner.plugins.PluginException;
import org.specrunner.util.xom.INodeHolder;
import org.specrunner.util.xom.NodeHolder;
import org.specrunner.util.xom.TableAdapter;

public final class UtilNode {
    public static final String IGNORE = "ignore";
    public static final String ATT_CSS = "class";
    public static final String CSS_LETF = "left";
    public static final String CSS_RIGHT = "right";

    private UtilNode() {
    }

    public static boolean isIgnore(Node node) {
        return node instanceof Element && ((Element)node).getAttribute(IGNORE) != null;
    }

    public static void setIgnore(Node node) {
        if (node instanceof Element) {
            ((Element)node).addAttribute(new Attribute(IGNORE, "true"));
        }
    }

    public static Node appendCss(Node node, String css) {
        if (node instanceof Element) {
            Element ele = (Element)node;
            Attribute att = ele.getAttribute(ATT_CSS);
            if (att == null) {
                ele.addAttribute(new Attribute(ATT_CSS, css));
            } else {
                String value = att.getValue();
                if (!value.contains(css)) {
                    att.setValue(value + " " + css);
                }
            }
        }
        return node;
    }

    public static void removeCss(Node node, String css) {
        Element ele;
        Attribute att;
        if (node instanceof Element && (att = (ele = (Element)node).getAttribute(ATT_CSS)) != null) {
            att.setValue(att.getValue().toLowerCase().replace(css, ""));
        }
    }

    public static String getChildrenAsString(Node parent) {
        StringBuilder str = new StringBuilder();
        Nodes children = parent.query("child::node()");
        for (int i = 0; i < children.size(); ++i) {
            str.append(children.get(i).toXML());
        }
        return str.toString();
    }

    public static Node getHighest(Nodes nodes) {
        Node result = null;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < nodes.size(); ++i) {
            Node n = nodes.get(i);
            int t = UtilNode.getDepth(n);
            if (t >= min) continue;
            result = n;
            min = t;
        }
        return result;
    }

    public static int getDepth(Node node) {
        int i = 0;
        ParentNode parent = node.getParent();
        while (parent != null) {
            parent = parent.getParent();
            ++i;
        }
        return i;
    }

    public static boolean matches(Node node, String xpath) {
        return node.getDocument().query(xpath).contains(node);
    }

    public static boolean isTable(Node node) {
        return node instanceof Element && "table".equalsIgnoreCase(((Element)node).getQualifiedName());
    }

    public static TableAdapter newTableAdapter(Node node) {
        if (!UtilNode.isTable(node)) {
            throw new IllegalArgumentException("Node is not a table.");
        }
        return new TableAdapter((Element)node);
    }

    public static INodeHolder newNodeHolder(Node node) {
        return new NodeHolder(node);
    }

    public static Node getLeft(Node root) throws PluginException {
        return UtilNode.getCssNode(root, CSS_LETF);
    }

    public static Node getRight(Node root) throws PluginException {
        return UtilNode.getCssNode(root, CSS_RIGHT);
    }

    public static Node getCssNode(Node root, String css) throws PluginException {
        Attribute n;
        if (root instanceof Element && (n = ((Element)root).getAttribute(css)) != null) {
            return n;
        }
        Nodes exps = root.query("descendant::*[contains(@class,'" + css + "')]");
        Node expected = UtilNode.getHighest(exps);
        if (expected == null) {
            throw new PluginException("Expected value not found. Missing a element with class='" + css + "' in element:" + root.toXML());
        }
        return expected;
    }

    public static boolean isElement(Node node, String tag) {
        if (node instanceof Element) {
            return ((Element)node).getQualifiedName().equals(tag);
        }
        return false;
    }
}

