/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.hibernate4;

import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.specrunner.context.IContext;
import org.specrunner.hibernate4.PluginSessionFactory;
import org.specrunner.plugins.core.objects.AbstractPluginObject;
import org.specrunner.plugins.core.objects.IObjectSelector;
import org.specrunner.result.IResultSet;
import org.specrunner.util.xom.node.RowAdapter;

public class ObjectSelector
implements IObjectSelector<Session> {
    private static ThreadLocal<ObjectSelector> instance = new ThreadLocal<ObjectSelector>(){

        @Override
        protected ObjectSelector initialValue() {
            return new ObjectSelector();
        }
    };
    protected Session session;

    public static ObjectSelector get() {
        return instance.get();
    }

    public Session getSource(AbstractPluginObject caller, IContext context) throws Exception {
        if (this.session == null) {
            SessionFactory sf = PluginSessionFactory.getSessionFactory(context, caller.getName());
            this.session = sf.openSession();
        }
        return this.session;
    }

    public List<Object> all(AbstractPluginObject caller, IContext context, IResultSet result) throws Exception {
        this.session = this.getSource(caller, context);
        return this.session.createCriteria(instance.getClass()).list();
    }

    public List<Object> select(AbstractPluginObject caller, IContext context, Object instance, RowAdapter row, IResultSet result) throws Exception {
        this.session = this.getSource(caller, context);
        Criteria c = this.session.createCriteria(instance.getClass());
        String[] keyFields = caller.getReference().split(",");
        for (int i = 0; i < keyFields.length; ++i) {
            c.add((Criterion)Restrictions.eq((String)keyFields[i], (Object)PropertyUtils.getProperty((Object)instance, (String)keyFields[i])));
        }
        return c.list();
    }

    public void release() throws Exception {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }
}

