/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.hibernate4;

import java.lang.reflect.Method;
import java.util.Iterator;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.specrunner.SRServices;
import org.specrunner.concurrency.IConcurrentMapping;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.hibernate4.AbstractPluginFactory;
import org.specrunner.hibernate4.IConfigurationProvider;
import org.specrunner.hibernate4.PluginInsert;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.objects.AbstractPluginObject;
import org.specrunner.plugins.core.objects.IObjectManager;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Success;
import org.specrunner.util.UtilLog;

public class PluginConfiguration
extends AbstractPluginFactory {
    public static final String SESSION_CONFIGURATION = "sessionConfiguration";
    public static final String FEATURE_TYPE = PluginConfiguration.class.getName() + ".type";
    public static final String FEATURE_FACTORY = PluginConfiguration.class.getName() + ".factory";
    public static final String FEATURE_METHOD = PluginConfiguration.class.getName() + ".method";

    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        if (this.type == null) {
            fm.set(FEATURE_TYPE, (Object)this);
        }
        if (this.factory == null) {
            fm.set(FEATURE_FACTORY, (Object)this);
        }
        if (this.method == null) {
            fm.set(FEATURE_METHOD, (Object)this);
        }
    }

    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        if (this.type == null && (this.factory == null || this.method == null)) {
            throw new PluginException("Parameter 'type', or 'factory' and 'method' missing. In 'type' use an subtype of IConfigurationProvider, or choose a class in 'factory' whose 'method' is static and returns a Hibernate Configuration.");
        }
        try {
            Class<?> typeInstance;
            Configuration cfg = null;
            if (this.type != null) {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Configuration by type: " + this.type + ".");
                }
                typeInstance = Class.forName(this.type);
                IConfigurationProvider conf = (IConfigurationProvider)typeInstance.newInstance();
                cfg = conf.getConfiguration();
            } else {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Configuration by factory/method: " + this.factory + "." + this.method + "()");
                }
                typeInstance = Class.forName(this.factory);
                Method m = typeInstance.getMethod(this.method, new Class[0]);
                cfg = (Configuration)m.invoke(null, new Object[0]);
            }
            if (this.getThreadsafe().booleanValue()) {
                this.changeUrl(context, cfg);
            }
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Configuration: " + cfg + ".");
            }
            String str = this.getName() != null ? this.getName() : SESSION_CONFIGURATION;
            context.saveGlobal(str, (Object)cfg);
            result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
            ((IObjectManager)SRServices.get(IObjectManager.class)).clear();
            Iterator ite = cfg.getClassMappings();
            while (ite.hasNext()) {
                PersistentClass persistent = (PersistentClass)ite.next();
                PluginInsert pin = new PluginInsert();
                pin.setTypeInstance(Class.forName(persistent.getClassName()));
                ((IObjectManager)SRServices.get(IObjectManager.class)).bind((AbstractPluginObject)pin);
            }
        }
        catch (Exception e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new PluginException((Throwable)e);
        }
        return ENext.SKIP;
    }

    protected void changeUrl(IContext context, Configuration cfg) {
        String url = String.valueOf(((IConcurrentMapping)SRServices.get(IConcurrentMapping.class)).get("url", (Object)cfg.getProperty("hibernate.connection.url")));
        cfg.setProperty("hibernate.connection.url", url);
        Node node = context.getNode();
        if (node instanceof Element) {
            Element ele = (Element)node;
            Attribute att = ele.getAttribute("title");
            if (att == null) {
                att = new Attribute("title", "");
                ele.addAttribute(att);
            }
            att.setValue("URL='" + url + "'");
        }
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Connection URL set to '" + url + "'.");
        }
    }

    public static Configuration getConfiguration(IContext context, String name) throws PluginException {
        String str = name != null ? name : SESSION_CONFIGURATION;
        Configuration cfg = (Configuration)context.getByName(str);
        if (cfg == null) {
            throw new PluginException("Instance of '" + str + "' not found. Use " + PluginConfiguration.class.getName() + " before.");
        }
        return cfg;
    }
}

